/***********************************************************************************
* System Monitor: Plasmoid and data engines to monitor CPU/Memory/Swap Usage.
* Copyright (C) 2008  Matthew Dawson
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef SYSTEM_MONITOR_H
#define SYSTEM_MONITOR_H

#include <Plasma/Applet>
#include <Plasma/Svg>
#include <Plasma/DataEngine>

#include "ui_coloursConfig.h"
#include "ui_generalConfig.h"

class QString;
class QSizeF;
class QPainter;
class QStyleOptionGraphicsItem;

class systemMonitor : public Plasma::Applet{
Q_OBJECT

public:
	systemMonitor(QObject *parent, const QVariantList &args);
	~systemMonitor();

	void constraintsEvent(Plasma::Constraints constraints);

	void paintInterface(QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect& contentsRect);
	void init();

protected slots:
	void dataUpdated(const QString& source, const Plasma::DataEngine::Data &data);
	void configUpdated();

private:
	void paintCPUUsage(QPainter *p, const QStyleOptionGraphicsItem *option, const QRect& contentsRect);
	void paintSwapUsage(QPainter *p, const QStyleOptionGraphicsItem *option, const QRect& contentsRect);
	void paintRAMUsage(QPainter *p, const QStyleOptionGraphicsItem *option, const QRect& contentsRect);
	void readConfig();
	void createConfigurationInterface(KConfigDialog *parent);

	Plasma::Svg m_svg;
	double m_user, m_sys, m_nice, m_idle, m_disk;
	double m_ramfree, m_ramused, m_rambuffers, m_ramcached;
	double m_swapfree, m_swapused;

	Ui::generalConfig uiGeneral;
	Ui::coloursConfig uiColours;

	bool m_isVertical;
	QColor m_cpuUserColour;
	QColor m_cpuNiceColour;
	QColor m_cpuDiskColour;
	QColor m_cpuSysColour;
	QColor m_ramCachedColour;
	QColor m_ramBuffersColour;
	QColor m_ramUsedColour;
	QColor m_swapUsedColour;
};

K_EXPORT_PLASMA_APPLET(system_monitor, systemMonitor)

#endif
