/***********************************************************************************
* STasks
* Copyright (C) 2009 Marcin Baszczewski <marcin.baszczewski@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/ 
#ifndef STASKSLIGHT_H
#define STASKSLIGHT_H

//QT
#include <QObject>
#include <QPixmap>
#include <QIcon>
class QTimer;
class QStyleOptionGraphicsItem;
class STasksApplet;
class STasksLight : public QObject
{
    Q_OBJECT
    public:
	STasksLight(QObject *parent,STasksApplet *applet);
	~STasksLight();
	void paint(QPainter *p, const QStyleOptionGraphicsItem *option, QWidget *widget);
	void setRect(QRectF geometry);
	void setPoint(QPointF point);
	void setMouse(bool mouse);
    public Q_SLOTS:
	void startAnimation(QString animation,int duration=300,bool repeater=true);
        void stopAnimation();
        void repeatAnimation();
    private Q_SLOTS:
	void animation(qreal progress);
    private:
	STasksApplet *m_applet;
	QRectF m_rect;
	int m_count;
	int m_currentAnimationDuration;
        int m_animation;
	qreal m_progress;
	bool m_move;
	QString m_currentAnimation;
	QTimer *m_animationRepeater;
	bool m_repeater;
	QPointF m_point;
	bool m_mouse;
    Q_SIGNALS:
	void update();
};
#endif
