/***********************************************************************************
* STasks
* Copyright (C) 2009 Marcin Baszczewski <marcin.baszczewski@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/ 
#ifndef STASKSITEM_H
#define STASKSITEM_H

//QT
#include <QGraphicsWidget>
#include <QPixmap>
#include <QTime>
#include <QTimer>
//PLASMA
#include <Plasma/IconWidget>
//OTHER
#include <taskmanager/taskmanager.h>
#include <taskmanager/abstractgroupableitem.h>
#include <taskmanager/groupmanager.h>
#include <taskmanager/taskitem.h>
#include <taskmanager/startup.h>
#include <taskmanager/taskactions.h>

class STasksIcon;
class STasksTask;
class STasksApplet;
class STasksFrame;
class STasksLight;
class STasksToolTip;
class QPainter;
class QStyleOptionGraphicsItem;
class PeachyApplet;
class QRectF;
class QSizeF;
class QGraphicsSceneHoverEvent;
class QTextOption;
class QTextLayout;

using TaskManager::GroupPtr;

namespace Plasma
{
    class FrameSvg;
}


class STasksItem : public QGraphicsWidget
{
    Q_OBJECT

    public:
	STasksItem(TaskManager::AbstractGroupableItem *abstractItem, STasksApplet *parent);
	~STasksItem();
	qreal size() const;
      
	qreal m_width;
	qreal m_height;
	qreal m_additionalSize;
	bool m_expanded;
    public Q_SLOTS:
	void activate();
	void setSize(qreal size);
	void update();
	void updateState();
	void updateToolTip();
	STasksTask *task();
	void toggleToolTip();
    private:
	STasksIcon *m_icon;
	STasksApplet *m_applet;
	STasksTask *m_task;
	STasksFrame *m_frame;
	STasksLight *m_light;
	//STasksToolTip *m_toolTip;
// 	STasksToolTip *m_previewToolTip;
	long int m_lastUpdate;
        TaskManager::AbstractGroupableItem *m_abstractItem;

	Plasma::FrameSvg *m_background;
	QString m_oldBackgroundPrefix;
	QString m_backgroundPrefix;

	qreal m_size;
	int m_animId;
	qreal m_alpha;
	bool m_fadeIn : 1;
	QTimer* m_activateTimer;
	QTimer* m_updateTimer;
	QTimer* m_toolTipTimer;
	bool m_mouseIn;
	int m_animationId;
	QHash<QString, int> m_animations;
	void drawText(QPainter *p, const QStyleOptionGraphicsItem *option, QWidget *widget);
	int m_expand;
	QPoint popupPosition(QSize size, bool center);
	void blockToolTip();
	void expandTask(int duration,bool expandIn);
	QRect iconGeometry() const;
    private Q_SLOTS:
	void publishIconGeometry();
	void animationExpandTask1(qreal progress);
	void animationExpandTask2(qreal progress);
    protected:
	 virtual void dropEvent(QGraphicsSceneDragDropEvent *event);
	void contextMenuEvent(QGraphicsSceneContextMenuEvent *event);
	void paint(QPainter *p, const QStyleOptionGraphicsItem *option, QWidget *widget);
	void hoverEnterEvent(QGraphicsSceneHoverEvent *);
	void hoverLeaveEvent(QGraphicsSceneHoverEvent *event);
	void hoverMoveEvent(QGraphicsSceneHoverEvent* e);
	void mousePressEvent(QGraphicsSceneMouseEvent *event);
	void mouseMoveEvent(QGraphicsSceneMouseEvent *event);
	void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);
	void dragEnterEvent(QGraphicsSceneDragDropEvent *event);
	void dragMoveEvent(QGraphicsSceneDragDropEvent *event);
	void dragLeaveEvent(QGraphicsSceneDragDropEvent *event);
	//text
	QSize layoutText(QTextLayout &layout, const QString &text, const QSize &constraints) const;
	void drawTextLayout(QPainter *painter, const QTextLayout &layout, const QRect &rect) const;
	QColor textColor() const;
    signals:
	void itemActive(STasksItem* icon);
};
#endif
