/***********************************************************************************
* STasks
* Copyright (C) 2009 Marcin Baszczewski <marcin.baszczewski@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/ 
#ifndef STASKSICON_H
#define STASKSICON_H

//QT
#include <QObject>
#include <QPixmap>
#include <QIcon>
class QTimer;
class QStyleOptionGraphicsItem;
class STasksApplet;

class STasksIcon : public QObject
{
    Q_OBJECT
    public:
	STasksIcon(QObject *parent,STasksApplet *applet);
	~STasksIcon();
	enum IconType { Other = 0, Startup, Task, Group };
	void paint(QPainter *p, const QStyleOptionGraphicsItem *option, QWidget *widget);
	void setRect(QRectF geometry);
	void setIcon(QIcon icon);
	void setType(IconType type);
	IconType type();
	qreal size();
    public Q_SLOTS:
	void updateIcon(QIcon icon);
	void startAnimation(QString animation,int duration=300,bool repeater=true);
        void stopAnimation();
        void repeatAnimation();
    private Q_SLOTS:
	void animation(qreal progress);
    private:
	STasksApplet *m_applet;
	QIcon m_icon;
	QRectF m_rect;
	QPixmap m_pixmap;
	QString m_currentAnimation;
	QTimer *m_animationRepeater;
	int m_currentAnimationDuration;
        int m_animation;
	qreal m_progress;
	int m_count;
	double m_scale;
	//config
	bool m_repeater;
	QPointF getPos();
	IconType m_type;
	void animationMouseInIcon(qreal progress);
	void animationMouseOutIcon(qreal progress);
	void animationStartup(qreal progress);
    Q_SIGNALS:
	void update();
};
#endif
