/***********************************************************************************
* STasks
* Copyright (C) 2009 Marcin Baszczewski <marcin.baszczewski@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef STASKSAPPLET_H
#define STASKSAPPLET_H

//UI
#include "ui_stasksConfigG.h"
#include "ui_stasksConfigA.h"
//QT
#include <QList>
//PLASMA
#include <Plasma/Applet>
#include <Plasma/IconWidget>
#include <Plasma/DataEngine>
//KDE
#include <KDialog>
//TASKMANAGER
#include <taskmanager/startup.h>
#include <taskmanager/taskitem.h>
#include <taskmanager/taskmanager.h>
#include <taskmanager/groupmanager.h>
#include <taskmanager/abstractgroupableitem.h>

class STasksTask;
class STasksItem;
class STasksFrame;
class STasksLayout;
class STasksToolTip;

class QGraphicsLinearLayout;

using TaskManager::StartupPtr;
using TaskManager::TaskPtr;
using TaskManager::StartupPtr;
using TaskManager::GroupPtr;
using TaskManager::AbstractItemPtr;
using TaskManager::AbstractGroupableItem;
using TaskManager::GroupManager;
using TaskManager::TaskItem;
using TaskManager::TaskGroup;

namespace Plasma
{
    class FrameSvg;
}

class STasksApplet : public Plasma::Applet
{
    Q_OBJECT
    public:
        STasksApplet(QObject *parent, const QVariantList &args);
	~STasksApplet();
        void init();
	//other
	Plasma::FrameSvg *m_frame;
        GroupManager *m_groupManager;
	STasksToolTip *m_toolTip;
	void dropEvent(QGraphicsSceneDragDropEvent *event);
	//config
	QColor lightColor() {return m_lightColor;} 
	TaskManager::GroupManager::TaskGroupingStrategy groupingStrategy() {return m_groupingStrategy;}
	TaskManager::GroupManager::TaskSortingStrategy sortingStrategy() {return m_sortingStrategy;}
	bool lights() {return m_lights;}
	bool expandTasks() {return m_expandTasks;}
	int keepExpanded() {return m_keepExpanded;}
	double iconScale() {return (double) m_iconScale/100;}
	int expandingSize() {return m_expandingSize;}	
	int animationDuration() {return m_animationDuration;}	
	int iconShape() {return m_shape;}
	int fps() {return 35;}
    private:
	QGraphicsLinearLayout *m_layout;
	QHash<AbstractItemPtr, STasksItem*> m_tasksHash;
	qreal m_iconSize;
	Ui::stasksConfigG m_configG;
	Ui::stasksConfigA m_configA;
	void reload();
	void constraintsEvent(Plasma::Constraints constraints);
	int totalSubTasks();
	AbstractItemPtr selectSubTask(int index);
	int activeIndex();
	//task
        TaskManager::GroupManager::TaskGroupingStrategy m_groupingStrategy;
	TaskManager::GroupManager::TaskSortingStrategy m_sortingStrategy;
	//config
	QList<STasksItem*> m_items;
	int m_taskSpacing;
	int m_animationDuration;
	int m_expandingSize;
	int m_iconScale;
	bool m_lights;
	int m_expandTasks;
	int m_keepExpanded;
	QColor m_lightColor;
	int m_shape;
	int m_activeIconIndex;
    protected:
        void createConfigurationInterface(KConfigDialog *parent);
        void wheelEvent(QGraphicsSceneWheelEvent *event);

    public slots:
	void updateSize();
	void updateActiveIconIndex(STasksItem *item);
	void itemPositionChanged(AbstractItemPtr groupableItem);
	void expandTasksChanged(int state);
	void lightColorChanged(int state);
    private slots:
	void configuration();
	void itemAdded(AbstractItemPtr groupableItem);
	void itemRemoved(AbstractItemPtr groupableItem);
    protected slots:
        void configAccepted();
    signals:
	void settingsChanged();
        void setSize(qreal size);
};

#endif
