/***********************************************************************************
* Run Command: Simple plasmoid to run commands with support for runners.
* Copyright (C) 2008 - 2009 Michal Dutkiewicz aka Emdek <emdeck@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#include "RunCommandItem.h"

#include <QHBoxLayout>

#include <KMenu>

#include <Plasma/Theme>
#include <Plasma/PaintUtils>

RunCommandItem::RunCommandItem(QIcon icon, QString title, QString description, QList<QAction*> actions, QWidget *parent) : QWidget(parent)
{
    m_actions = actions;

    QLabel *titleLabel = new QLabel(QString("%1<br /><i>%2</i>").arg(title).arg(description), this);
    titleLabel->setTextInteractionFlags(Qt::NoTextInteraction);

    m_iconLabel = new QLabel(this);
    m_iconLabel->setPixmap(icon.pixmap(32, 32));
    m_iconLabel->setEnabled(false);

    QHBoxLayout *layout = new QHBoxLayout(this);
    layout->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
    layout->addWidget(m_iconLabel);
    layout->addWidget(titleLabel);

    setLayout(layout);

    setToolTip(QString("<b>%1</b><br /><i>%2</i>").arg(title).arg(description));

    setFixedSize(340, 40);
}

void RunCommandItem::paintEvent(QPaintEvent *event)
{
    QPainter painter(this);
    painter.setRenderHints(QPainter::Antialiasing);
    painter.setClipRect(event->rect());

    if (underMouse())
    {
        QPainterPath path = Plasma::PaintUtils::roundedRectangle(rect(), 5);

        painter.setPen(Plasma::Theme::defaultTheme()->color(Plasma::Theme::TextColor));
        painter.fillPath(path, Plasma::Theme::defaultTheme()->color(Plasma::Theme::BackgroundColor).lighter());
        painter.drawPath(path);

        m_iconLabel->setEnabled(true);
    }
    else
    {
        m_iconLabel->setEnabled(false);
    }
}

void RunCommandItem::enterEvent(QEvent *event)
{
    Q_UNUSED(event)

    update();
}

void RunCommandItem::leaveEvent(QEvent *event)
{
    Q_UNUSED(event)

    update();
}

void RunCommandItem::mousePressEvent(QMouseEvent *event)
{
    if (event->button() == Qt::LeftButton)
    {
        emit run();
    }
}

void RunCommandItem::contextMenuEvent(QContextMenuEvent *event)
{
    Q_UNUSED(event)

    if (m_actions.count())
    {
        KMenu *menu = new KMenu;
        menu->addActions(m_actions);
        menu->exec();

        delete menu;
    }
}
