/******************************************************************************
*                                PlayWolf                                     *
*******************************************************************************
*                                                                             *
*                   Copyright (C) 2008-2009 Giulio Camuffo		      *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License along   *
*   with this program; if not, write to the Free Software Foundation, Inc.,   *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA                *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#ifndef WOLFLABEL_H
#define WOLFLABEL_H

#include <QtGui/QGraphicsWidget>

class QTimeLine;
class QGraphicsItemAnimation;

namespace KIO {
    class Job;
};

namespace Plasma {
    class Label;
};

class WolfLabel : public QGraphicsWidget
{
    Q_OBJECT

    public:
	WolfLabel(QGraphicsWidget *parent);
	~WolfLabel();
        enum DIRECTION{
            RIGHT,
            LEFT,
            STOPPED
        };
	void resizeEvent(QGraphicsSceneResizeEvent *event);
	bool isResizeFont();
	int minimumFont();
	void setResizeFont(bool resize, int min);
	void setFont(QFont customFont = QFont());
	QFont font();
	QSizeF labelSize();
	bool contains(const QPointF& point) const;

    public slots:
	void setText(const QString& text);
	void setImage(const QString& path);
	void clear(void);

    private:
	void adjustFont();
	void scrollLabel();
	void updateLabel(QString mode = "");

	QTimeLine *timer;
	QGraphicsItemAnimation *animation;
	QFont myFont;
	QPixmap image;
	Plasma::Label *label;
	bool resizeFont;
	int minFont;

};

#endif