/******************************************************************************
*                                PlayWolf                                     *
*******************************************************************************
*                                                                             *
*                   Copyright (C) 2008-2009 Giulio Camuffo		      *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License along   *
*   with this program; if not, write to the Free Software Foundation, Inc.,   *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA                *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#ifndef BUTTONS_H
#define BUTTONS_H
 
#include <QtGui/QGraphicsWidget>

class FlowLayout;

namespace Plasma {
    class IconWidget;
};

class WolfButtons : public QGraphicsWidget
{
    Q_OBJECT
    public:
        WolfButtons(QGraphicsWidget *parent);
        ~WolfButtons();

        enum STATUS{
	    PLAYING,
	    PAUSED,
            STOPPED,
            CLOSED
        };

	void setAmarokButtonShown(bool amarokShow);
	bool isAmarokButtonShown(void);

	void resizeEvent(QGraphicsSceneResizeEvent *event);

    public slots:
	void setStatus(const int &);

    signals:
	void playPausePressed(void);
	void stopPressed(void);
	void prevPressed(void);
	void nextPressed(void);
	void showAmarokPressed(void);

    private:
	void adjustLayoutSpacing();

	Plasma::IconWidget *playPause;
	Plasma::IconWidget *stop;
	Plasma::IconWidget *prev;
	Plasma::IconWidget *next;
	Plasma::IconWidget *showAmarok;
	FlowLayout *layout;
};
 
#endif
