/******************************************************************************
*                                PlayWolf                                     *
*******************************************************************************
*                                                                             *
*                   Copyright (C) 2008-2009 Giulio Camuffo		      *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License along   *
*   with this program; if not, write to the Free Software Foundation, Inc.,   *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA                *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#ifndef INFOWIDGET_H
#define INFOWIDGET_H
 
#include <QtGui/QGraphicsWidget>

class FlowLayout;
class WolfLabel;

class InfoWidget : public QGraphicsWidget {

    Q_OBJECT
    public:
        InfoWidget(QGraphicsWidget *parent);
        ~InfoWidget();

	void setResizeFont(bool resize, int minFont);
	bool resizeFont(void);
	int  minimumFont(void);
	void setFont(QFont font);
	QFont font(void);
	bool contains(const QPointF& point) const;

    public slots:
	void setInfos(const QString& artist, const QString& album, const QString& title);
	void setPosition(const int position, const int songTime);
	void clear(void);

    private:
	FlowLayout *m_layout;
	WolfLabel *m_title;
	WolfLabel *m_artist;
	WolfLabel *m_album;
	WolfLabel *m_time;

};
 
#endif
