/******************************************************************************
*                                PlayWolf                                     *
*******************************************************************************
*                                                                             *
*                   Copyright (C) 2008-2009 Giulio Camuffo		      *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License along   *
*   with this program; if not, write to the Free Software Foundation, Inc.,   *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA                *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#include "infowidget.h"

#include "flowlayout.h"
#include "wolflabel.h"

InfoWidget::InfoWidget(QGraphicsWidget *parent)
    : QGraphicsWidget(parent)
{
    m_layout = new FlowLayout(this);
    m_layout->setOrientation(FlowLayout::Vertical);
    m_layout->setContentsMargins(0,0,0,0);
    m_layout->setPrimarySpacing(0);
    m_layout->setSecondarySpacing(6);
    setLayout(m_layout);

    m_title = new WolfLabel(this);
    m_artist = new WolfLabel(this);
    m_album = new WolfLabel(this);
    m_time = new WolfLabel(this);

    m_title->setMinimumSize(10,10);
    m_artist->setMinimumSize(10,10);
    m_album->setMinimumSize(10,10);
    m_time->setMinimumSize(10,10);
    
    m_layout->addItem(m_title);
    m_layout->addItem(m_artist);
    m_layout->addItem(m_album);
    m_layout->addItem(m_time);
}
 
InfoWidget::~InfoWidget() {
}

void InfoWidget::setInfos(const QString& artist, const QString& album, const QString& title) {
    m_artist->setText(artist);
    m_album->setText(album);
    m_title->setText(title);
}

void InfoWidget::setPosition(const int position, const int songTime) {
    if ((position != -1) and (songTime != -1)) {
	int songLenght = songTime/1000;
	int pos = position/1000;

	QString posSeconds;
	QString totSeconds;
	if (pos%60 < 10)
	    posSeconds = QString("0" + QVariant(pos%60).toString());
	else
	    posSeconds = QString(QVariant(pos%60).toString());

	if (songLenght%60 < 10)
	    totSeconds = QString("0" + QVariant(songLenght%60).toString());
	else
	    totSeconds = QString(QVariant(songLenght%60).toString());

	m_time->setText(QString(QVariant(pos/60).toString() + ":" + posSeconds + "/" + QVariant(songLenght/60).toString() + ":" + totSeconds));
    }
}

void InfoWidget::setResizeFont(bool resize, int minFont) {
    m_title->setResizeFont(resize,minFont);
    m_artist->setResizeFont(resize,minFont);
    m_album->setResizeFont(resize,minFont);
    m_time->setResizeFont(resize,minFont);
}

bool InfoWidget::resizeFont() {
    return m_title->isResizeFont();
}

int InfoWidget::minimumFont() {
    return m_title->minimumFont();
}

void InfoWidget::setFont(QFont font) {
    m_title->setFont(font);
    m_album->setFont(font);
    m_artist->setFont(font);
    m_time->setFont(font);
}

QFont InfoWidget::font() {
    return m_title->font();
}

void InfoWidget::clear() {
    m_title->setText("");
    m_album->setText("");
    m_artist->setText("");
    m_time->setText("");
}

bool InfoWidget::contains(const QPointF& point) const {
    QRectF rect = geometry();

    return ((point.x() >= rect.x()) and (point.x() <= (rect.x() + rect.width())) and
	    (point.y() >= rect.y()) and (point.y() <= (rect.y() + rect.height())));
}

#include "infowidget.moc"
