/******************************************************************************
*                                PlayWolf                                     *
*******************************************************************************
*                                                                             *
*                   Copyright (C) 2009 Giulio Camuffo			      *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License along   *
*   with this program; if not, write to the Free Software Foundation, Inc.,   *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA                *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#include "dialogwidget.h"

#include <QtGui/QGraphicsLinearLayout>
#include <QtCore/QStringList>
#include <KIcon>
#include <Plasma/Slider>
#include "infowidget.h"
#include "ratingwidget.h"
#include "playercontroller.h"
#include "wolflabel.h"

DialogWidget::DialogWidget(QGraphicsWidget *parent)
    : QGraphicsWidget(parent)
{
    layout = new QGraphicsLinearLayout(this);
    volumeSlider = new Plasma::Slider(this);
    ratingWidget = new RatingWidget(this);
    firstNextSong = new WolfLabel(this);
    secondNextSong = new WolfLabel(this);
    thirdNextSong = new WolfLabel(this);

    layout->setOrientation(Qt::Vertical);

    volumeSlider->setRange(0,100);
    volumeSlider->setOrientation(Qt::Horizontal);

    ratingWidget->setMaxRating(5);
    ratingWidget->setHalfStepsEnabled(false);

    layout->addItem(ratingWidget);
    layout->addItem(volumeSlider);
    layout->addItem(firstNextSong);
    layout->addItem(secondNextSong);
    layout->addItem(thirdNextSong);
    setLayout(layout);

    connect(volumeSlider ,SIGNAL(valueChanged(int)), this, SLOT(sliderChanged(int)));
//     connect(ratingWidget ,SIGNAL(ratingChanged(unsigned int)), this, SIGNAL(ratingChanged(unsigned int)));
}

DialogWidget::~DialogWidget(void) {

}

void DialogWidget::setVolume(const int& volume) {
    acceptSliderSignal = false;
    volumeSlider->setValue(volume);
}

void DialogWidget::sliderChanged(int value) {
    if (acceptSliderSignal)
	emit volumeChanged(value);
    else
	acceptSliderSignal = true;
}

void DialogWidget::setRating(const int& rating) {
    ratingWidget->setRating(rating);
}

void DialogWidget::setPlaylist(const QStringList& playlist) {
    if (playlist.size() > 0)
	firstNextSong->setText(playlist.at(0));
    else
	firstNextSong->setText("");
    if (playlist.size() > 1)
	secondNextSong->setText(playlist.at(1));
    else
	secondNextSong->setText("");
    if (playlist.size() > 2)
	thirdNextSong->setText(playlist.at(2));
    else
	thirdNextSong->setText("");
}

void DialogWidget::updateContents() {
    setRating(PlayerController::self()->rating());
    setVolume(PlayerController::self()->volume());
}

#include "dialogwidget.moc"
