/****************************************************************************
 *   Copyright (C) 2009 by Björn Ruberg <bjoern@ruberg-wegener.de>         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/


#include <qx11info_x11.h>
#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>

#ifndef KEYMAP_H_
#define KEYMAP_H_

class Helpers {
public:


	static unsigned int keycodeToKeysym(unsigned int code, int level){
		unsigned int keysym;
		#ifdef Q_WS_X11
			keysym = (unsigned int)XKeycodeToKeysym(QX11Info::display(), code, level);
		#else
			keysym = 0;
		#endif
		return keysym;
	}

	static unsigned int keysymToKeycode(unsigned int code){
		#ifdef Q_WS_X11
			return ((unsigned int) XKeysymToKeycode(QX11Info::display(), code));
		#else
			return 0;
		#endif
	}

	static void fakeKeyPress(unsigned int code){
		#ifdef Q_WS_X11
		XTestFakeKeyEvent(QX11Info::display(), code, true, 0);
		#endif
	}
	static void fakeKeyRelease(unsigned int code){
		#ifdef Q_WS_X11
		XTestFakeKeyEvent(QX11Info::display(), code, false, 0);
		#endif
	}

	// what follows is a long and ugly list of mappings

	static short mapToUnicode(unsigned int keysym){
		static int map[0xffff+1];
		static bool buildUp = false;

		if(keysym >= 0xffff){
			return 0;
		}

		if(!buildUp){

		map[0x0020]=0x0020;
		map[0x0021]=0x0021;
		map[0x0022]=0x0022;
		map[0x0023]=0x0023;
		map[0x0024]=0x0024;
		map[0x0025]=0x0025;
		map[0x0026]=0x0026;
		map[0x0027]=0x0027;
		map[0x0027]=0x0027;
		map[0x0028]=0x0028;
		map[0x0029]=0x0029;
		map[0x002a]=0x002a;
		map[0x002b]=0x002b;
		map[0x002c]=0x002c;
		map[0x002d]=0x002d;
		map[0x002e]=0x002e;
		map[0x002f]=0x002f;
		map[0x0030]=0x0030;
		map[0x0031]=0x0031;
		map[0x0032]=0x0032;
		map[0x0033]=0x0033;
		map[0x0034]=0x0034;
		map[0x0035]=0x0035;
		map[0x0036]=0x0036;
		map[0x0037]=0x0037;
		map[0x0038]=0x0038;
		map[0x0039]=0x0039;
		map[0x003a]=0x003a;
		map[0x003b]=0x003b;
		map[0x003c]=0x003c;
		map[0x003d]=0x003d;
		map[0x003e]=0x003e;
		map[0x003f]=0x003f;
		map[0x0040]=0x0040;
		map[0x0041]=0x0041;
		map[0x0042]=0x0042;
		map[0x0043]=0x0043;
		map[0x0044]=0x0044;
		map[0x0045]=0x0045;
		map[0x0046]=0x0046;
		map[0x0047]=0x0047;
		map[0x0048]=0x0048;
		map[0x0049]=0x0049;
		map[0x004a]=0x004a;
		map[0x004b]=0x004b;
		map[0x004c]=0x004c;
		map[0x004d]=0x004d;
		map[0x004e]=0x004e;
		map[0x004f]=0x004f;
		map[0x0050]=0x0050;
		map[0x0051]=0x0051;
		map[0x0052]=0x0052;
		map[0x0053]=0x0053;
		map[0x0054]=0x0054;
		map[0x0055]=0x0055;
		map[0x0056]=0x0056;
		map[0x0057]=0x0057;
		map[0x0058]=0x0058;
		map[0x0059]=0x0059;
		map[0x005a]=0x005a;
		map[0x005b]=0x005b;
		map[0x005c]=0x005c;
		map[0x005d]=0x005d;
		map[0x005e]=0x005e;
		map[0x005f]=0x005f;
		map[0x0060]=0x0060;
		map[0x0060]=0x0060;
		map[0x0061]=0x0061;
		map[0x0062]=0x0062;
		map[0x0063]=0x0063;
		map[0x0064]=0x0064;
		map[0x0065]=0x0065;
		map[0x0066]=0x0066;
		map[0x0067]=0x0067;
		map[0x0068]=0x0068;
		map[0x0069]=0x0069;
		map[0x006a]=0x006a;
		map[0x006b]=0x006b;
		map[0x006c]=0x006c;
		map[0x006d]=0x006d;
		map[0x006e]=0x006e;
		map[0x006f]=0x006f;
		map[0x0070]=0x0070;
		map[0x0071]=0x0071;
		map[0x0072]=0x0072;
		map[0x0073]=0x0073;
		map[0x0074]=0x0074;
		map[0x0075]=0x0075;
		map[0x0076]=0x0076;
		map[0x0077]=0x0077;
		map[0x0078]=0x0078;
		map[0x0079]=0x0079;
		map[0x007a]=0x007a;
		map[0x007b]=0x007b;
		map[0x007c]=0x007c;
		map[0x007d]=0x007d;
		map[0x007e]=0x007e;
		map[0x00a0]=0x00a0;
		map[0x00a1]=0x00a1;
		map[0x00a2]=0x00a2;
		map[0x00a3]=0x00a3;
		map[0x00a4]=0x00a4;
		map[0x00a5]=0x00a5;
		map[0x00a6]=0x00a6;
		map[0x00a7]=0x00a7;
		map[0x00a8]=0x00a8;
		map[0x00a9]=0x00a9;
		map[0x00aa]=0x00aa;
		map[0x00ab]=0x00ab;
		map[0x00ac]=0x00ac;
		map[0x00ad]=0x00ad;
		map[0x00ae]=0x00ae;
		map[0x00af]=0x00af;
		map[0x00b0]=0x00b0;
		map[0x00b1]=0x00b1;
		map[0x00b2]=0x00b2;
		map[0x00b3]=0x00b3;
		map[0x00b4]=0x00b4;
		map[0x00b5]=0x00b5;
		map[0x00b6]=0x00b6;
		map[0x00b7]=0x00b7;
		map[0x00b8]=0x00b8;
		map[0x00b9]=0x00b9;
		map[0x00ba]=0x00ba;
		map[0x00bb]=0x00bb;
		map[0x00bc]=0x00bc;
		map[0x00bd]=0x00bd;
		map[0x00be]=0x00be;
		map[0x00bf]=0x00bf;
		map[0x00c0]=0x00c0;
		map[0x00c1]=0x00c1;
		map[0x00c2]=0x00c2;
		map[0x00c3]=0x00c3;
		map[0x00c4]=0x00c4;
		map[0x00c5]=0x00c5;
		map[0x00c6]=0x00c6;
		map[0x00c7]=0x00c7;
		map[0x00c8]=0x00c8;
		map[0x00c9]=0x00c9;
		map[0x00ca]=0x00ca;
		map[0x00cb]=0x00cb;
		map[0x00cc]=0x00cc;
		map[0x00cd]=0x00cd;
		map[0x00ce]=0x00ce;
		map[0x00cf]=0x00cf;
		map[0x00d0]=0x00d0;
		map[0x00d0]=0x00d0;
		map[0x00d1]=0x00d1;
		map[0x00d2]=0x00d2;
		map[0x00d3]=0x00d3;
		map[0x00d4]=0x00d4;
		map[0x00d5]=0x00d5;
		map[0x00d6]=0x00d6;
		map[0x00d7]=0x00d7;
		map[0x00d8]=0x00d8;
		map[0x00d9]=0x00d9;
		map[0x00da]=0x00da;
		map[0x00db]=0x00db;
		map[0x00dc]=0x00dc;
		map[0x00dd]=0x00dd;
		map[0x00de]=0x00de;
		map[0x00de]=0x00de;
		map[0x00df]=0x00df;
		map[0x00e0]=0x00e0;
		map[0x00e1]=0x00e1;
		map[0x00e2]=0x00e2;
		map[0x00e3]=0x00e3;
		map[0x00e4]=0x00e4;
		map[0x00e5]=0x00e5;
		map[0x00e6]=0x00e6;
		map[0x00e7]=0x00e7;
		map[0x00e8]=0x00e8;
		map[0x00e9]=0x00e9;
		map[0x00ea]=0x00ea;
		map[0x00eb]=0x00eb;
		map[0x00ec]=0x00ec;
		map[0x00ed]=0x00ed;
		map[0x00ee]=0x00ee;
		map[0x00ef]=0x00ef;
		map[0x00f0]=0x00f0;
		map[0x00f1]=0x00f1;
		map[0x00f2]=0x00f2;
		map[0x00f3]=0x00f3;
		map[0x00f4]=0x00f4;
		map[0x00f5]=0x00f5;
		map[0x00f6]=0x00f6;
		map[0x00f7]=0x00f7;
		map[0x00f8]=0x00f8;
		map[0x00f9]=0x00f9;
		map[0x00fa]=0x00fa;
		map[0x00fb]=0x00fb;
		map[0x00fc]=0x00fc;
		map[0x00fd]=0x00fd;
		map[0x00fe]=0x00fe;
		map[0x00ff]=0x00ff;
		map[0x01a1]=0x0104;
		map[0x01a2]=0x02d8;
		map[0x01a3]=0x0141;
		map[0x01a5]=0x013d;
		map[0x01a6]=0x015a;
		map[0x01a9]=0x0160;
		map[0x01aa]=0x015e;
		map[0x01ab]=0x0164;
		map[0x01ac]=0x0179;
		map[0x01ae]=0x017d;
		map[0x01af]=0x017b;
		map[0x01b1]=0x0105;
		map[0x01b2]=0x02db;
		map[0x01b3]=0x0142;
		map[0x01b5]=0x013e;
		map[0x01b6]=0x015b;
		map[0x01b7]=0x02c7;
		map[0x01b9]=0x0161;
		map[0x01ba]=0x015f;
		map[0x01bb]=0x0165;
		map[0x01bc]=0x017a;
		map[0x01bd]=0x02dd;
		map[0x01be]=0x017e;
		map[0x01bf]=0x017c;
		map[0x01c0]=0x0154;
		map[0x01c3]=0x0102;
		map[0x01c5]=0x0139;
		map[0x01c6]=0x0106;
		map[0x01c8]=0x010c;
		map[0x01ca]=0x0118;
		map[0x01cc]=0x011a;
		map[0x01cf]=0x010e;
		map[0x01d0]=0x0110;
		map[0x01d1]=0x0143;
		map[0x01d2]=0x0147;
		map[0x01d5]=0x0150;
		map[0x01d8]=0x0158;
		map[0x01d9]=0x016e;
		map[0x01db]=0x0170;
		map[0x01de]=0x0162;
		map[0x01e0]=0x0155;
		map[0x01e3]=0x0103;
		map[0x01e5]=0x013a;
		map[0x01e6]=0x0107;
		map[0x01e8]=0x010d;
		map[0x01ea]=0x0119;
		map[0x01ec]=0x011b;
		map[0x01ef]=0x010f;
		map[0x01f0]=0x0111;
		map[0x01f1]=0x0144;
		map[0x01f2]=0x0148;
		map[0x01f5]=0x0151;
		map[0x01f8]=0x0159;
		map[0x01f9]=0x016f;
		map[0x01fb]=0x0171;
		map[0x01fe]=0x0163;
		map[0x01ff]=0x02d9;
		map[0x02a1]=0x0126;
		map[0x02a6]=0x0124;
		map[0x02a9]=0x0130;
		map[0x02ab]=0x011e;
		map[0x02ac]=0x0134;
		map[0x02b1]=0x0127;
		map[0x02b6]=0x0125;
		map[0x02b9]=0x0131;
		map[0x02bb]=0x011f;
		map[0x02bc]=0x0135;
		map[0x02c5]=0x010a;
		map[0x02c6]=0x0108;
		map[0x02d5]=0x0120;
		map[0x02d8]=0x011c;
		map[0x02dd]=0x016c;
		map[0x02de]=0x015c;
		map[0x02e5]=0x010b;
		map[0x02e6]=0x0109;
		map[0x02f5]=0x0121;
		map[0x02f8]=0x011d;
		map[0x02fd]=0x016d;
		map[0x02fe]=0x015d;
		map[0x03a2]=0x0138;
		map[0x03a3]=0x0156;
		map[0x03a5]=0x0128;
		map[0x03a6]=0x013b;
		map[0x03aa]=0x0112;
		map[0x03ab]=0x0122;
		map[0x03ac]=0x0166;
		map[0x03b3]=0x0157;
		map[0x03b5]=0x0129;
		map[0x03b6]=0x013c;
		map[0x03ba]=0x0113;
		map[0x03bb]=0x0123;
		map[0x03bc]=0x0167;
		map[0x03bd]=0x014a;
		map[0x03bf]=0x014b;
		map[0x03c0]=0x0100;
		map[0x03c7]=0x012e;
		map[0x03cc]=0x0116;
		map[0x03cf]=0x012a;
		map[0x03d1]=0x0145;
		map[0x03d2]=0x014c;
		map[0x03d3]=0x0136;
		map[0x03d9]=0x0172;
		map[0x03dd]=0x0168;
		map[0x03de]=0x016a;
		map[0x03e0]=0x0101;
		map[0x03e7]=0x012f;
		map[0x03ec]=0x0117;
		map[0x03ef]=0x012b;
		map[0x03f1]=0x0146;
		map[0x03f2]=0x014d;
		map[0x03f3]=0x0137;
		map[0x03f9]=0x0173;
		map[0x03fd]=0x0169;
		map[0x03fe]=0x016b;
		map[0x047e]=0x203e;
		map[0x04a1]=0x3002;
		map[0x04a2]=0x300c;
		map[0x04a3]=0x300d;
		map[0x04a4]=0x3001;
		map[0x04a5]=0x30fb;
		map[0x04a6]=0x30f2;
		map[0x04a7]=0x30a1;
		map[0x04a8]=0x30a3;
		map[0x04a9]=0x30a5;
		map[0x04aa]=0x30a7;
		map[0x04ab]=0x30a9;
		map[0x04ac]=0x30e3;
		map[0x04ad]=0x30e5;
		map[0x04ae]=0x30e7;
		map[0x04af]=0x30c3;
		map[0x04b0]=0x30fc;
		map[0x04b1]=0x30a2;
		map[0x04b2]=0x30a4;
		map[0x04b3]=0x30a6;
		map[0x04b4]=0x30a8;
		map[0x04b5]=0x30aa;
		map[0x04b6]=0x30ab;
		map[0x04b7]=0x30ad;
		map[0x04b8]=0x30af;
		map[0x04b9]=0x30b1;
		map[0x04ba]=0x30b3;
		map[0x04bb]=0x30b5;
		map[0x04bc]=0x30b7;
		map[0x04bd]=0x30b9;
		map[0x04be]=0x30bb;
		map[0x04bf]=0x30bd;
		map[0x04c0]=0x30bf;
		map[0x04c1]=0x30c1;
		map[0x04c2]=0x30c4;
		map[0x04c3]=0x30c6;
		map[0x04c4]=0x30c8;
		map[0x04c5]=0x30ca;
		map[0x04c6]=0x30cb;
		map[0x04c7]=0x30cc;
		map[0x04c8]=0x30cd;
		map[0x04c9]=0x30ce;
		map[0x04ca]=0x30cf;
		map[0x04cb]=0x30d2;
		map[0x04cc]=0x30d5;
		map[0x04cd]=0x30d8;
		map[0x04ce]=0x30db;
		map[0x04cf]=0x30de;
		map[0x04d0]=0x30df;
		map[0x04d1]=0x30e0;
		map[0x04d2]=0x30e1;
		map[0x04d3]=0x30e2;
		map[0x04d4]=0x30e4;
		map[0x04d5]=0x30e6;
		map[0x04d6]=0x30e8;
		map[0x04d7]=0x30e9;
		map[0x04d8]=0x30ea;
		map[0x04d9]=0x30eb;
		map[0x04da]=0x30ec;
		map[0x04db]=0x30ed;
		map[0x04dc]=0x30ef;
		map[0x04dd]=0x30f3;
		map[0x04de]=0x309b;
		map[0x04df]=0x309c;
		map[0x05ac]=0x060c;
		map[0x05bb]=0x061b;
		map[0x05bf]=0x061f;
		map[0x05c1]=0x0621;
		map[0x05c2]=0x0622;
		map[0x05c3]=0x0623;
		map[0x05c4]=0x0624;
		map[0x05c5]=0x0625;
		map[0x05c6]=0x0626;
		map[0x05c7]=0x0627;
		map[0x05c8]=0x0628;
		map[0x05c9]=0x0629;
		map[0x05ca]=0x062a;
		map[0x05cb]=0x062b;
		map[0x05cc]=0x062c;
		map[0x05cd]=0x062d;
		map[0x05ce]=0x062e;
		map[0x05cf]=0x062f;
		map[0x05d0]=0x0630;
		map[0x05d1]=0x0631;
		map[0x05d2]=0x0632;
		map[0x05d3]=0x0633;
		map[0x05d4]=0x0634;
		map[0x05d5]=0x0635;
		map[0x05d6]=0x0636;
		map[0x05d7]=0x0637;
		map[0x05d8]=0x0638;
		map[0x05d9]=0x0639;
		map[0x05da]=0x063a;
		map[0x05e0]=0x0640;
		map[0x05e1]=0x0641;
		map[0x05e2]=0x0642;
		map[0x05e3]=0x0643;
		map[0x05e4]=0x0644;
		map[0x05e5]=0x0645;
		map[0x05e6]=0x0646;
		map[0x05e7]=0x0647;
		map[0x05e8]=0x0648;
		map[0x05e9]=0x0649;
		map[0x05ea]=0x064a;
		map[0x05eb]=0x064b;
		map[0x05ec]=0x064c;
		map[0x05ed]=0x064d;
		map[0x05ee]=0x064e;
		map[0x05ef]=0x064f;
		map[0x05f0]=0x0650;
		map[0x05f1]=0x0651;
		map[0x05f2]=0x0652;
		map[0x06a1]=0x0452;
		map[0x06a2]=0x0453;
		map[0x06a3]=0x0451;
		map[0x06a4]=0x0454;
		map[0x06a5]=0x0455;
		map[0x06a6]=0x0456;
		map[0x06a7]=0x0457;
		map[0x06a8]=0x0458;
		map[0x06a9]=0x0459;
		map[0x06aa]=0x045a;
		map[0x06ab]=0x045b;
		map[0x06ac]=0x045c;
		map[0x06ae]=0x045e;
		map[0x06af]=0x045f;
		map[0x06b0]=0x2116;
		map[0x06b1]=0x0402;
		map[0x06b2]=0x0403;
		map[0x06b3]=0x0401;
		map[0x06b4]=0x0404;
		map[0x06b5]=0x0405;
		map[0x06b6]=0x0406;
		map[0x06b7]=0x0407;
		map[0x06b8]=0x0408;
		map[0x06b9]=0x0409;
		map[0x06ba]=0x040a;
		map[0x06bb]=0x040b;
		map[0x06bc]=0x040c;
		map[0x06be]=0x040e;
		map[0x06bf]=0x040f;
		map[0x06c0]=0x044e;
		map[0x06c1]=0x0430;
		map[0x06c2]=0x0431;
		map[0x06c3]=0x0446;
		map[0x06c4]=0x0434;
		map[0x06c5]=0x0435;
		map[0x06c6]=0x0444;
		map[0x06c7]=0x0433;
		map[0x06c8]=0x0445;
		map[0x06c9]=0x0438;
		map[0x06ca]=0x0439;
		map[0x06cb]=0x043a;
		map[0x06cc]=0x043b;
		map[0x06cd]=0x043c;
		map[0x06ce]=0x043d;
		map[0x06cf]=0x043e;
		map[0x06d0]=0x043f;
		map[0x06d1]=0x044f;
		map[0x06d2]=0x0440;
		map[0x06d3]=0x0441;
		map[0x06d4]=0x0442;
		map[0x06d5]=0x0443;
		map[0x06d6]=0x0436;
		map[0x06d7]=0x0432;
		map[0x06d8]=0x044c;
		map[0x06d9]=0x044b;
		map[0x06da]=0x0437;
		map[0x06db]=0x0448;
		map[0x06dc]=0x044d;
		map[0x06dd]=0x0449;
		map[0x06de]=0x0447;
		map[0x06df]=0x044a;
		map[0x06e0]=0x042e;
		map[0x06e1]=0x0410;
		map[0x06e2]=0x0411;
		map[0x06e3]=0x0426;
		map[0x06e4]=0x0414;
		map[0x06e5]=0x0415;
		map[0x06e6]=0x0424;
		map[0x06e7]=0x0413;
		map[0x06e8]=0x0425;
		map[0x06e9]=0x0418;
		map[0x06ea]=0x0419;
		map[0x06eb]=0x041a;
		map[0x06ec]=0x041b;
		map[0x06ed]=0x041c;
		map[0x06ee]=0x041d;
		map[0x06ef]=0x041e;
		map[0x06f0]=0x041f;
		map[0x06f1]=0x042f;
		map[0x06f2]=0x0420;
		map[0x06f3]=0x0421;
		map[0x06f4]=0x0422;
		map[0x06f5]=0x0423;
		map[0x06f6]=0x0416;
		map[0x06f7]=0x0412;
		map[0x06f8]=0x042c;
		map[0x06f9]=0x042b;
		map[0x06fa]=0x0417;
		map[0x06fb]=0x0428;
		map[0x06fc]=0x042d;
		map[0x06fd]=0x0429;
		map[0x06fe]=0x0427;
		map[0x06ff]=0x042a;
		map[0x07a1]=0x0386;
		map[0x07a2]=0x0388;
		map[0x07a3]=0x0389;
		map[0x07a4]=0x038a;
		map[0x07a5]=0x03aa;
		map[0x07a7]=0x038c;
		map[0x07a8]=0x038e;
		map[0x07a9]=0x03ab;
		map[0x07ab]=0x038f;
		map[0x07ae]=0x0385;
		map[0x07af]=0x2015;
		map[0x07b1]=0x03ac;
		map[0x07b2]=0x03ad;
		map[0x07b3]=0x03ae;
		map[0x07b4]=0x03af;
		map[0x07b5]=0x03ca;
		map[0x07b6]=0x0390;
		map[0x07b7]=0x03cc;
		map[0x07b8]=0x03cd;
		map[0x07b9]=0x03cb;
		map[0x07ba]=0x03b0;
		map[0x07bb]=0x03ce;
		map[0x07c1]=0x0391;
		map[0x07c2]=0x0392;
		map[0x07c3]=0x0393;
		map[0x07c4]=0x0394;
		map[0x07c5]=0x0395;
		map[0x07c6]=0x0396;
		map[0x07c7]=0x0397;
		map[0x07c8]=0x0398;
		map[0x07c9]=0x0399;
		map[0x07ca]=0x039a;
		map[0x07cb]=0x039b;
		map[0x07cb]=0x039b;
		map[0x07cc]=0x039c;
		map[0x07cd]=0x039d;
		map[0x07ce]=0x039e;
		map[0x07cf]=0x039f;
		map[0x07d0]=0x03a0;
		map[0x07d1]=0x03a1;
		map[0x07d2]=0x03a3;
		map[0x07d4]=0x03a4;
		map[0x07d5]=0x03a5;
		map[0x07d6]=0x03a6;
		map[0x07d7]=0x03a7;
		map[0x07d8]=0x03a8;
		map[0x07d9]=0x03a9;
		map[0x07e1]=0x03b1;
		map[0x07e2]=0x03b2;
		map[0x07e3]=0x03b3;
		map[0x07e4]=0x03b4;
		map[0x07e5]=0x03b5;
		map[0x07e6]=0x03b6;
		map[0x07e7]=0x03b7;
		map[0x07e8]=0x03b8;
		map[0x07e9]=0x03b9;
		map[0x07ea]=0x03ba;
		map[0x07eb]=0x03bb;
		map[0x07ec]=0x03bc;
		map[0x07ed]=0x03bd;
		map[0x07ee]=0x03be;
		map[0x07ef]=0x03bf;
		map[0x07f0]=0x03c0;
		map[0x07f1]=0x03c1;
		map[0x07f2]=0x03c3;
		map[0x07f3]=0x03c2;
		map[0x07f4]=0x03c4;
		map[0x07f5]=0x03c5;
		map[0x07f6]=0x03c6;
		map[0x07f7]=0x03c7;
		map[0x07f8]=0x03c8;
		map[0x07f9]=0x03c9;
		map[0x08a1]=0x23b7;
		map[0x08a2]=0x250c;
		map[0x08a3]=0x2500;
		map[0x08a4]=0x2320;
		map[0x08a5]=0x2321;
		map[0x08a6]=0x2502;
		map[0x08a7]=0x23a1;
		map[0x08a8]=0x23a3;
		map[0x08a9]=0x23a4;
		map[0x08aa]=0x23a6;
		map[0x08ab]=0x239b;
		map[0x08ac]=0x239d;
		map[0x08ad]=0x239e;
		map[0x08ae]=0x23a0;
		map[0x08af]=0x23a8;
		map[0x08b0]=0x23ac;
		map[0x08b1]=0x0000;
		map[0x08b2]=0x0000;
		map[0x08b3]=0x0000;
		map[0x08b4]=0x0000;
		map[0x08b5]=0x0000;
		map[0x08b6]=0x0000;
		map[0x08b7]=0x0000;
		map[0x08bc]=0x2264;
		map[0x08bd]=0x2260;
		map[0x08be]=0x2265;
		map[0x08bf]=0x222b;
		map[0x08c0]=0x2234;
		map[0x08c1]=0x221d;
		map[0x08c2]=0x221e;
		map[0x08c5]=0x2207;
		map[0x08c8]=0x223c;
		map[0x08c9]=0x2243;
		map[0x08cd]=0x21d4;
		map[0x08ce]=0x21d2;
		map[0x08cf]=0x2261;
		map[0x08d6]=0x221a;
		map[0x08da]=0x2282;
		map[0x08db]=0x2283;
		map[0x08dc]=0x2229;
		map[0x08dd]=0x222a;
		map[0x08de]=0x2227;
		map[0x08df]=0x2228;
		map[0x08ef]=0x2202;
		map[0x08f6]=0x0192;
		map[0x08fb]=0x2190;
		map[0x08fc]=0x2191;
		map[0x08fd]=0x2192;
		map[0x08fe]=0x2193;
		map[0x09df]=0x0000;
		map[0x09e0]=0x25c6;
		map[0x09e1]=0x2592;
		map[0x09e2]=0x2409;
		map[0x09e3]=0x240c;
		map[0x09e4]=0x240d;
		map[0x09e5]=0x240a;
		map[0x09e8]=0x2424;
		map[0x09e9]=0x240b;
		map[0x09ea]=0x2518;
		map[0x09eb]=0x2510;
		map[0x09ec]=0x250c;
		map[0x09ed]=0x2514;
		map[0x09ee]=0x253c;
		map[0x09ef]=0x23ba;
		map[0x09f0]=0x23bb;
		map[0x09f1]=0x2500;
		map[0x09f2]=0x23bc;
		map[0x09f3]=0x23bd;
		map[0x09f4]=0x251c;
		map[0x09f5]=0x2524;
		map[0x09f6]=0x2534;
		map[0x09f7]=0x252c;
		map[0x09f8]=0x2502;
		map[0x0aa1]=0x2003;
		map[0x0aa2]=0x2002;
		map[0x0aa3]=0x2004;
		map[0x0aa4]=0x2005;
		map[0x0aa5]=0x2007;
		map[0x0aa6]=0x2008;
		map[0x0aa7]=0x2009;
		map[0x0aa8]=0x200a;
		map[0x0aa9]=0x2014;
		map[0x0aaa]=0x2013;
		map[0x0aac]=0x2423;
		map[0x0aae]=0x2026;
		map[0x0aaf]=0x2025;
		map[0x0ab0]=0x2153;
		map[0x0ab1]=0x2154;
		map[0x0ab2]=0x2155;
		map[0x0ab3]=0x2156;
		map[0x0ab4]=0x2157;
		map[0x0ab5]=0x2158;
		map[0x0ab6]=0x2159;
		map[0x0ab7]=0x215a;
		map[0x0ab8]=0x2105;
		map[0x0abb]=0x2012;
		map[0x0abc]=0x27e8;
		map[0x0abd]=0x002e;
		map[0x0abe]=0x27e9;
		map[0x0abf]=0x0000;
		map[0x0ac3]=0x215b;
		map[0x0ac4]=0x215c;
		map[0x0ac5]=0x215d;
		map[0x0ac6]=0x215e;
		map[0x0ac9]=0x2122;
		map[0x0aca]=0x2613;
		map[0x0acb]=0x0000;
		map[0x0acc]=0x25c1;
		map[0x0acd]=0x25b7;
		map[0x0ace]=0x25cb;
		map[0x0acf]=0x25af;
		map[0x0ad0]=0x2018;
		map[0x0ad1]=0x2019;
		map[0x0ad2]=0x201c;
		map[0x0ad3]=0x201d;
		map[0x0ad4]=0x211e;
		map[0x0ad6]=0x2032;
		map[0x0ad7]=0x2033;
		map[0x0ad9]=0x271d;
		map[0x0ada]=0x0000;
		map[0x0adb]=0x25ac;
		map[0x0adc]=0x25c0;
		map[0x0add]=0x25b6;
		map[0x0ade]=0x25cf;
		map[0x0adf]=0x25ae;
		map[0x0ae0]=0x25e6;
		map[0x0ae1]=0x25ab;
		map[0x0ae2]=0x25ad;
		map[0x0ae3]=0x25b3;
		map[0x0ae4]=0x25bd;
		map[0x0ae5]=0x2606;
		map[0x0ae6]=0x2022;
		map[0x0ae7]=0x25aa;
		map[0x0ae8]=0x25b2;
		map[0x0ae9]=0x25bc;
		map[0x0aea]=0x261c;
		map[0x0aeb]=0x261e;
		map[0x0aec]=0x2663;
		map[0x0aed]=0x2666;
		map[0x0aee]=0x2665;
		map[0x0af0]=0x2720;
		map[0x0af1]=0x2020;
		map[0x0af2]=0x2021;
		map[0x0af3]=0x2713;
		map[0x0af4]=0x2717;
		map[0x0af5]=0x266f;
		map[0x0af6]=0x266d;
		map[0x0af7]=0x2642;
		map[0x0af8]=0x2640;
		map[0x0af9]=0x260e;
		map[0x0afa]=0x2315;
		map[0x0afb]=0x2117;
		map[0x0afc]=0x2038;
		map[0x0afd]=0x201a;
		map[0x0afe]=0x201e;
		map[0x0aff]=0x0000;
		map[0x0ba3]=0x003c;
		map[0x0ba6]=0x003e;
		map[0x0ba8]=0x2228;
		map[0x0ba9]=0x2227;
		map[0x0bc0]=0x00af;
		map[0x0bc2]=0x22a5;
		map[0x0bc3]=0x2229;
		map[0x0bc4]=0x230a;
		map[0x0bc6]=0x005f;
		map[0x0bca]=0x2218;
		map[0x0bcc]=0x2395;
		map[0x0bce]=0x22a4;
		map[0x0bcf]=0x25cb;
		map[0x0bd3]=0x2308;
		map[0x0bd6]=0x222a;
		map[0x0bd8]=0x2283;
		map[0x0bda]=0x2282;
		map[0x0bdc]=0x22a2;
		map[0x0bfc]=0x22a3;
		map[0x0cdf]=0x2017;
		map[0x0ce0]=0x05d0;
		map[0x0ce1]=0x05d1;
		map[0x0ce1]=0x05d1;
		map[0x0ce2]=0x05d2;
		map[0x0ce2]=0x05d2;
		map[0x0ce3]=0x05d3;
		map[0x0ce3]=0x05d3;
		map[0x0ce4]=0x05d4;
		map[0x0ce5]=0x05d5;
		map[0x0ce6]=0x05d6;
		map[0x0ce6]=0x05d6;
		map[0x0ce7]=0x05d7;
		map[0x0ce7]=0x05d7;
		map[0x0ce8]=0x05d8;
		map[0x0ce8]=0x05d8;
		map[0x0ce9]=0x05d9;
		map[0x0cea]=0x05da;
		map[0x0ceb]=0x05db;
		map[0x0cec]=0x05dc;
		map[0x0ced]=0x05dd;
		map[0x0cee]=0x05de;
		map[0x0cef]=0x05df;
		map[0x0cf0]=0x05e0;
		map[0x0cf1]=0x05e1;
		map[0x0cf1]=0x05e1;
		map[0x0cf2]=0x05e2;
		map[0x0cf3]=0x05e3;
		map[0x0cf4]=0x05e4;
		map[0x0cf5]=0x05e5;
		map[0x0cf5]=0x05e5;
		map[0x0cf6]=0x05e6;
		map[0x0cf6]=0x05e6;
		map[0x0cf7]=0x05e7;
		map[0x0cf7]=0x05e7;
		map[0x0cf8]=0x05e8;
		map[0x0cf9]=0x05e9;
		map[0x0cfa]=0x05ea;
		map[0x0cfa]=0x05ea;
		map[0x0da1]=0x0e01;
		map[0x0da2]=0x0e02;
		map[0x0da3]=0x0e03;
		map[0x0da4]=0x0e04;
		map[0x0da5]=0x0e05;
		map[0x0da6]=0x0e06;
		map[0x0da7]=0x0e07;
		map[0x0da8]=0x0e08;
		map[0x0da9]=0x0e09;
		map[0x0daa]=0x0e0a;
		map[0x0dab]=0x0e0b;
		map[0x0dac]=0x0e0c;
		map[0x0dad]=0x0e0d;
		map[0x0dae]=0x0e0e;
		map[0x0daf]=0x0e0f;
		map[0x0db0]=0x0e10;
		map[0x0db1]=0x0e11;
		map[0x0db2]=0x0e12;
		map[0x0db3]=0x0e13;
		map[0x0db4]=0x0e14;
		map[0x0db5]=0x0e15;
		map[0x0db6]=0x0e16;
		map[0x0db7]=0x0e17;
		map[0x0db8]=0x0e18;
		map[0x0db9]=0x0e19;
		map[0x0dba]=0x0e1a;
		map[0x0dbb]=0x0e1b;
		map[0x0dbc]=0x0e1c;
		map[0x0dbd]=0x0e1d;
		map[0x0dbe]=0x0e1e;
		map[0x0dbf]=0x0e1f;
		map[0x0dc0]=0x0e20;
		map[0x0dc1]=0x0e21;
		map[0x0dc2]=0x0e22;
		map[0x0dc3]=0x0e23;
		map[0x0dc4]=0x0e24;
		map[0x0dc5]=0x0e25;
		map[0x0dc6]=0x0e26;
		map[0x0dc7]=0x0e27;
		map[0x0dc8]=0x0e28;
		map[0x0dc9]=0x0e29;
		map[0x0dca]=0x0e2a;
		map[0x0dcb]=0x0e2b;
		map[0x0dcc]=0x0e2c;
		map[0x0dcd]=0x0e2d;
		map[0x0dce]=0x0e2e;
		map[0x0dcf]=0x0e2f;
		map[0x0dd0]=0x0e30;
		map[0x0dd1]=0x0e31;
		map[0x0dd2]=0x0e32;
		map[0x0dd3]=0x0e33;
		map[0x0dd4]=0x0e34;
		map[0x0dd5]=0x0e35;
		map[0x0dd6]=0x0e36;
		map[0x0dd7]=0x0e37;
		map[0x0dd8]=0x0e38;
		map[0x0dd9]=0x0e39;
		map[0x0dda]=0x0e3a;
		map[0x0dde]=0x0000;
		map[0x0ddf]=0x0e3f;
		map[0x0de0]=0x0e40;
		map[0x0de1]=0x0e41;
		map[0x0de2]=0x0e42;
		map[0x0de3]=0x0e43;
		map[0x0de4]=0x0e44;
		map[0x0de5]=0x0e45;
		map[0x0de6]=0x0e46;
		map[0x0de7]=0x0e47;
		map[0x0de8]=0x0e48;
		map[0x0de9]=0x0e49;
		map[0x0dea]=0x0e4a;
		map[0x0deb]=0x0e4b;
		map[0x0dec]=0x0e4c;
		map[0x0ded]=0x0e4d;
		map[0x0df0]=0x0e50;
		map[0x0df1]=0x0e51;
		map[0x0df2]=0x0e52;
		map[0x0df3]=0x0e53;
		map[0x0df4]=0x0e54;
		map[0x0df5]=0x0e55;
		map[0x0df6]=0x0e56;
		map[0x0df7]=0x0e57;
		map[0x0df8]=0x0e58;
		map[0x0df9]=0x0e59;
		map[0x0ea1]=0x3131;
		map[0x0ea2]=0x3132;
		map[0x0ea3]=0x3133;
		map[0x0ea4]=0x3134;
		map[0x0ea5]=0x3135;
		map[0x0ea6]=0x3136;
		map[0x0ea7]=0x3137;
		map[0x0ea8]=0x3138;
		map[0x0ea9]=0x3139;
		map[0x0eaa]=0x313a;
		map[0x0eab]=0x313b;
		map[0x0eac]=0x313c;
		map[0x0ead]=0x313d;
		map[0x0eae]=0x313e;
		map[0x0eaf]=0x313f;
		map[0x0eb0]=0x3140;
		map[0x0eb1]=0x3141;
		map[0x0eb2]=0x3142;
		map[0x0eb3]=0x3143;
		map[0x0eb4]=0x3144;
		map[0x0eb5]=0x3145;
		map[0x0eb6]=0x3146;
		map[0x0eb7]=0x3147;
		map[0x0eb8]=0x3148;
		map[0x0eb9]=0x3149;
		map[0x0eba]=0x314a;
		map[0x0ebb]=0x314b;
		map[0x0ebc]=0x314c;
		map[0x0ebd]=0x314d;
		map[0x0ebe]=0x314e;
		map[0x0ebf]=0x314f;
		map[0x0ec0]=0x3150;
		map[0x0ec1]=0x3151;
		map[0x0ec2]=0x3152;
		map[0x0ec3]=0x3153;
		map[0x0ec4]=0x3154;
		map[0x0ec5]=0x3155;
		map[0x0ec6]=0x3156;
		map[0x0ec7]=0x3157;
		map[0x0ec8]=0x3158;
		map[0x0ec9]=0x3159;
		map[0x0eca]=0x315a;
		map[0x0ecb]=0x315b;
		map[0x0ecc]=0x315c;
		map[0x0ecd]=0x315d;
		map[0x0ece]=0x315e;
		map[0x0ecf]=0x315f;
		map[0x0ed0]=0x3160;
		map[0x0ed1]=0x3161;
		map[0x0ed2]=0x3162;
		map[0x0ed3]=0x3163;
		map[0x0ed4]=0x11a8;
		map[0x0ed5]=0x11a9;
		map[0x0ed6]=0x11aa;
		map[0x0ed7]=0x11ab;
		map[0x0ed8]=0x11ac;
		map[0x0ed9]=0x11ad;
		map[0x0eda]=0x11ae;
		map[0x0edb]=0x11af;
		map[0x0edc]=0x11b0;
		map[0x0edd]=0x11b1;
		map[0x0ede]=0x11b2;
		map[0x0edf]=0x11b3;
		map[0x0ee0]=0x11b4;
		map[0x0ee1]=0x11b5;
		map[0x0ee2]=0x11b6;
		map[0x0ee3]=0x11b7;
		map[0x0ee4]=0x11b8;
		map[0x0ee5]=0x11b9;
		map[0x0ee6]=0x11ba;
		map[0x0ee7]=0x11bb;
		map[0x0ee8]=0x11bc;
		map[0x0ee9]=0x11bd;
		map[0x0eea]=0x11be;
		map[0x0eeb]=0x11bf;
		map[0x0eec]=0x11c0;
		map[0x0eed]=0x11c1;
		map[0x0eee]=0x11c2;
		map[0x0eef]=0x316d;
		map[0x0ef0]=0x3171;
		map[0x0ef1]=0x3178;
		map[0x0ef2]=0x317f;
		map[0x0ef3]=0x3181;
		map[0x0ef4]=0x3184;
		map[0x0ef5]=0x3186;
		map[0x0ef6]=0x318d;
		map[0x0ef7]=0x318e;
		map[0x0ef8]=0x11eb;
		map[0x0ef9]=0x11f0;
		map[0x0efa]=0x11f9;
		map[0x0eff]=0x20a9;
		map[0x13bc]=0x0152;
		map[0x13bd]=0x0153;
		map[0x13be]=0x0178;
		map[0x20a0]=0x20a0;
		map[0x20a1]=0x20a1;
		map[0x20a2]=0x20a2;
		map[0x20a3]=0x20a3;
		map[0x20a4]=0x20a4;
		map[0x20a5]=0x20a5;
		map[0x20a6]=0x20a6;
		map[0x20a7]=0x20a7;
		map[0x20a8]=0x20a8;
		map[0x20a9]=0x20a9;
		map[0x20aa]=0x20aa;
		map[0x20ab]=0x20ab;
		map[0x20ac]=0x20ac;
		map[0xfd01]=0x0000;
		map[0xfd02]=0x0000;
		map[0xfd03]=0x0000;
		map[0xfd04]=0x0000;
		map[0xfd05]=0x0000;
		map[0xfd06]=0x0000;
		map[0xfd07]=0x0000;
		map[0xfd08]=0x0000;
		map[0xfd09]=0x0000;
		map[0xfd0a]=0x0000;
		map[0xfd0b]=0x0000;
		map[0xfd0c]=0x0000;
		map[0xfd0d]=0x0000;
		map[0xfd0e]=0x0000;
		map[0xfd0f]=0x0000;
		map[0xfd10]=0x0000;
		map[0xfd11]=0x0000;
		map[0xfd12]=0x0000;
		map[0xfd13]=0x0000;
		map[0xfd14]=0x0000;
		map[0xfd15]=0x0000;
		map[0xfd16]=0x0000;
		map[0xfd17]=0x0000;
		map[0xfd18]=0x0000;
		map[0xfd19]=0x0000;
		map[0xfd1a]=0x0000;
		map[0xfd1b]=0x0000;
		map[0xfd1c]=0x0000;
		map[0xfd1d]=0x0000;
		map[0xfd1e]=0x0000;
		map[0xfe01]=0x0000;
		map[0xfe02]=0x0000;
		map[0xfe03]=0x0000;
		map[0xfe04]=0x0000;
		map[0xfe05]=0x0000;
		map[0xfe06]=0x0000;
		map[0xfe07]=0x0000;
		map[0xfe08]=0x0000;
		map[0xfe09]=0x0000;
		map[0xfe0a]=0x0000;
		map[0xfe0b]=0x0000;
		map[0xfe0c]=0x0000;
		map[0xfe0d]=0x0000;
		map[0xfe0e]=0x0000;
		map[0xfe0f]=0x0000;
		map[0xfe20]=0x0000;
		map[0xfe21]=0x0000;
		map[0xfe22]=0x0000;
		map[0xfe23]=0x0000;
		map[0xfe24]=0x0000;
		map[0xfe25]=0x0000;
		map[0xfe26]=0x0000;
		map[0xfe27]=0x0000;
		map[0xfe28]=0x0000;
		map[0xfe29]=0x0000;
		map[0xfe2a]=0x0000;
		map[0xfe2b]=0x0000;
		map[0xfe2c]=0x0000;
		map[0xfe2d]=0x0000;
		map[0xfe2e]=0x0000;
		map[0xfe2f]=0x0000;
		map[0xfe30]=0x0000;
		map[0xfe31]=0x0000;
		map[0xfe32]=0x0000;
		map[0xfe33]=0x0000;
		map[0xfe34]=0x0000;
		map[0xfe50]=0x0300;
		map[0xfe51]=0x0301;
		map[0xfe52]=0x0302;
		map[0xfe53]=0x0303;
		map[0xfe54]=0x0304;
		map[0xfe55]=0x0306;
		map[0xfe56]=0x0307;
		map[0xfe57]=0x0308;
		map[0xfe58]=0x030a;
		map[0xfe59]=0x030b;
		map[0xfe5a]=0x030c;
		map[0xfe5b]=0x0327;
		map[0xfe5c]=0x0328;
		map[0xfe5d]=0x0345;
		map[0xfe5e]=0x3099;
		map[0xfe5f]=0x309a;
		map[0xfe70]=0x0000;
		map[0xfe71]=0x0000;
		map[0xfe72]=0x0000;
		map[0xfe73]=0x0000;
		map[0xfe74]=0x0000;
		map[0xfe75]=0x0000;
		map[0xfe76]=0x0000;
		map[0xfe77]=0x0000;
		map[0xfe78]=0x0000;
		map[0xfe79]=0x0000;
		map[0xfe7a]=0x0000;
		map[0xfed0]=0x0000;
		map[0xfed1]=0x0000;
		map[0xfed2]=0x0000;
		map[0xfed4]=0x0000;
		map[0xfed5]=0x0000;
		map[0xfee0]=0x0000;
		map[0xfee1]=0x0000;
		map[0xfee2]=0x0000;
		map[0xfee3]=0x0000;
		map[0xfee4]=0x0000;
		map[0xfee5]=0x0000;
		map[0xfee6]=0x0000;
		map[0xfee7]=0x0000;
		map[0xfee8]=0x0000;
		map[0xfee9]=0x0000;
		map[0xfeea]=0x0000;
		map[0xfeeb]=0x0000;
		map[0xfeec]=0x0000;
		map[0xfeed]=0x0000;
		map[0xfeee]=0x0000;
		map[0xfeef]=0x0000;
		map[0xfef0]=0x0000;
		map[0xfef1]=0x0000;
		map[0xfef2]=0x0000;
		map[0xfef3]=0x0000;
		map[0xfef4]=0x0000;
		map[0xfef5]=0x0000;
		map[0xfef6]=0x0000;
		map[0xfef7]=0x0000;
		map[0xfef8]=0x0000;
		map[0xfef9]=0x0000;
		map[0xfefa]=0x0000;
		map[0xfefb]=0x0000;
		map[0xfefc]=0x0000;
		map[0xfefd]=0x0000;
		map[0xff08]=0x0008;
		map[0xff09]=0x0009;
		map[0xff0a]=0x000a;
		map[0xff0b]=0x000b;
		map[0xff0d]=0x000d;
		map[0xff13]=0x0013;
		map[0xff14]=0x0014;
		map[0xff15]=0x0015;
		map[0xff1b]=0x001b;
		map[0xff20]=0x0000;
		map[0xff21]=0x0000;
		map[0xff22]=0x0000;
		map[0xff23]=0x0000;
		map[0xff24]=0x0000;
		map[0xff25]=0x0000;
		map[0xff26]=0x0000;
		map[0xff27]=0x0000;
		map[0xff28]=0x0000;
		map[0xff29]=0x0000;
		map[0xff2a]=0x0000;
		map[0xff2b]=0x0000;
		map[0xff2c]=0x0000;
		map[0xff2d]=0x0000;
		map[0xff2e]=0x0000;
		map[0xff2f]=0x0000;
		map[0xff30]=0x0000;
		map[0xff31]=0x0000;
		map[0xff32]=0x0000;
		map[0xff33]=0x0000;
		map[0xff34]=0x0000;
		map[0xff35]=0x0000;
		map[0xff36]=0x0000;
		map[0xff37]=0x0000;
		map[0xff38]=0x0000;
		map[0xff39]=0x0000;
		map[0xff3a]=0x0000;
		map[0xff3b]=0x0000;
		map[0xff3c]=0x0000;
		map[0xff3d]=0x0000;
		map[0xff3e]=0x0000;
		map[0xff3f]=0x0000;
		map[0xff50]=0x0000;
		map[0xff51]=0x0000;
		map[0xff52]=0x0000;
		map[0xff53]=0x0000;
		map[0xff54]=0x0000;
		map[0xff55]=0x0000;
		map[0xff56]=0x0000;
		map[0xff57]=0x0000;
		map[0xff58]=0x0000;
		map[0xff60]=0x0000;
		map[0xff61]=0x0000;
		map[0xff62]=0x0000;
		map[0xff63]=0x0000;
		map[0xff65]=0x0000;
		map[0xff66]=0x0000;
		map[0xff67]=0x0000;
		map[0xff68]=0x0000;
		map[0xff69]=0x0000;
		map[0xff6a]=0x0000;
		map[0xff6b]=0x0000;
		map[0xff7e]=0x0000;
		map[0xff7f]=0x0000;
		map[0xff80]=0x0020;
		map[0xff89]=0x0009;
		map[0xff8d]=0x000d;
		map[0xff91]=0x0000;
		map[0xff92]=0x0000;
		map[0xff93]=0x0000;
		map[0xff94]=0x0000;
		map[0xff95]=0x0000;
		map[0xff96]=0x0000;
		map[0xff97]=0x0000;
		map[0xff98]=0x0000;
		map[0xff99]=0x0000;
		map[0xff9a]=0x0000;
		map[0xff9b]=0x0000;
		map[0xff9c]=0x0000;
		map[0xff9d]=0x0000;
		map[0xff9e]=0x0000;
		map[0xff9f]=0x0000;
		map[0xffaa]=0x002a;
		map[0xffab]=0x002b;
		map[0xffac]=0x002c;
		map[0xffad]=0x002d;
		map[0xffae]=0x002e;
		map[0xffaf]=0x002f;
		map[0xffb0]=0x0030;
		map[0xffb1]=0x0031;
		map[0xffb2]=0x0032;
		map[0xffb3]=0x0033;
		map[0xffb4]=0x0034;
		map[0xffb5]=0x0035;
		map[0xffb6]=0x0036;
		map[0xffb7]=0x0037;
		map[0xffb8]=0x0038;
		map[0xffb9]=0x0039;
		map[0xffbd]=0x003d;
		map[0xffbe]=0x0000;
		map[0xffbf]=0x0000;
		map[0xffc0]=0x0000;
		map[0xffc1]=0x0000;
		map[0xffc2]=0x0000;
		map[0xffc3]=0x0000;
		map[0xffc4]=0x0000;
		map[0xffc5]=0x0000;
		map[0xffc6]=0x0000;
		map[0xffc7]=0x0000;
		map[0xffc8]=0x0000;
		map[0xffc9]=0x0000;
		map[0xffca]=0x0000;
		map[0xffcb]=0x0000;
		map[0xffcc]=0x0000;
		map[0xffcd]=0x0000;
		map[0xffce]=0x0000;
		map[0xffcf]=0x0000;
		map[0xffd0]=0x0000;
		map[0xffd1]=0x0000;
		map[0xffd2]=0x0000;
		map[0xffd3]=0x0000;
		map[0xffd4]=0x0000;
		map[0xffd5]=0x0000;
		map[0xffd6]=0x0000;
		map[0xffd7]=0x0000;
		map[0xffd8]=0x0000;
		map[0xffd9]=0x0000;
		map[0xffda]=0x0000;
		map[0xffdb]=0x0000;
		map[0xffdc]=0x0000;
		map[0xffdd]=0x0000;
		map[0xffde]=0x0000;
		map[0xffdf]=0x0000;
		map[0xffe0]=0x0000;
		map[0xffe1]=0x0000;
		map[0xffe2]=0x0000;
		map[0xffe3]=0x0000;
		map[0xffe4]=0x0000;
		map[0xffe5]=0x0000;
		map[0xffe6]=0x0000;
		map[0xffe7]=0x0000;
		map[0xffe8]=0x0000;
		map[0xffe9]=0x0000;
		map[0xffea]=0x0000;
		map[0xffeb]=0x0000;
		map[0xffec]=0x0000;
		map[0xffed]=0x0000;
		map[0xffee]=0x0000;
		map[0xffff]=0x0000;
		map[0x06ad]=0x0491;
		map[0x06bd]=0x0490;
		map[0x14a1]=0x0000;
		map[0x14a2]=0x0587;
		map[0x14a3]=0x0589;
		map[0x14a4]=0x0029;
		map[0x14a5]=0x0028;
		map[0x14a6]=0x00bb;
		map[0x14a7]=0x00ab;
		map[0x14a8]=0x2014;
		map[0x14a9]=0x002e;
		map[0x14aa]=0x055d;
		map[0x14ab]=0x002c;
		map[0x14ac]=0x2013;
		map[0x14ad]=0x058a;
		map[0x14ae]=0x2026;
		map[0x14af]=0x055c;
		map[0x14b0]=0x055b;
		map[0x14b1]=0x055e;
		map[0x14b2]=0x0531;
		map[0x14b3]=0x0561;
		map[0x14b4]=0x0532;
		map[0x14b5]=0x0562;
		map[0x14b6]=0x0533;
		map[0x14b7]=0x0563;
		map[0x14b8]=0x0534;
		map[0x14b9]=0x0564;
		map[0x14ba]=0x0535;
		map[0x14bb]=0x0565;
		map[0x14bc]=0x0536;
		map[0x14bd]=0x0566;
		map[0x14be]=0x0537;
		map[0x14bf]=0x0567;
		map[0x14c0]=0x0538;
		map[0x14c1]=0x0568;
		map[0x14c2]=0x0539;
		map[0x14c3]=0x0569;
		map[0x14c4]=0x053a;
		map[0x14c5]=0x056a;
		map[0x14c6]=0x053b;
		map[0x14c7]=0x056b;
		map[0x14c8]=0x053c;
		map[0x14c9]=0x056c;
		map[0x14ca]=0x053d;
		map[0x14cb]=0x056d;
		map[0x14cc]=0x053e;
		map[0x14cd]=0x056e;
		map[0x14ce]=0x053f;
		map[0x14cf]=0x056f;
		map[0x14d0]=0x0540;
		map[0x14d1]=0x0570;
		map[0x14d2]=0x0541;
		map[0x14d3]=0x0571;
		map[0x14d4]=0x0542;
		map[0x14d5]=0x0572;
		map[0x14d6]=0x0543;
		map[0x14d7]=0x0573;
		map[0x14d8]=0x0544;
		map[0x14d9]=0x0574;
		map[0x14da]=0x0545;
		map[0x14db]=0x0575;
		map[0x14dc]=0x0546;
		map[0x14dd]=0x0576;
		map[0x14de]=0x0547;
		map[0x14df]=0x0577;
		map[0x14e0]=0x0548;
		map[0x14e1]=0x0578;
		map[0x14e2]=0x0549;
		map[0x14e3]=0x0579;
		map[0x14e4]=0x054a;
		map[0x14e5]=0x057a;
		map[0x14e6]=0x054b;
		map[0x14e7]=0x057b;
		map[0x14e8]=0x054c;
		map[0x14e9]=0x057c;
		map[0x14ea]=0x054d;
		map[0x14eb]=0x057d;
		map[0x14ec]=0x054e;
		map[0x14ed]=0x057e;
		map[0x14ee]=0x054f;
		map[0x14ef]=0x057f;
		map[0x14f0]=0x0550;
		map[0x14f1]=0x0580;
		map[0x14f2]=0x0551;
		map[0x14f3]=0x0581;
		map[0x14f4]=0x0552;
		map[0x14f5]=0x0582;
		map[0x14f6]=0x0553;
		map[0x14f7]=0x0583;
		map[0x14f8]=0x0554;
		map[0x14f9]=0x0584;
		map[0x14fa]=0x0555;
		map[0x14fb]=0x0585;
		map[0x14fc]=0x0556;
		map[0x14fd]=0x0586;
		map[0x14fe]=0x055a;
		map[0x14ff]=0x00a7;
		map[0x15d0]=0x10d0;
		map[0x15d1]=0x10d1;
		map[0x15d2]=0x10d2;
		map[0x15d3]=0x10d3;
		map[0x15d4]=0x10d4;
		map[0x15d5]=0x10d5;
		map[0x15d6]=0x10d6;
		map[0x15d7]=0x10d7;
		map[0x15d8]=0x10d8;
		map[0x15d9]=0x10d9;
		map[0x15da]=0x10da;
		map[0x15db]=0x10db;
		map[0x15dc]=0x10dc;
		map[0x15dd]=0x10dd;
		map[0x15de]=0x10de;
		map[0x15df]=0x10df;
		map[0x15e0]=0x10e0;
		map[0x15e1]=0x10e1;
		map[0x15e2]=0x10e2;
		map[0x15e3]=0x10e3;
		map[0x15e4]=0x10e4;
		map[0x15e5]=0x10e5;
		map[0x15e6]=0x10e6;
		map[0x15e7]=0x10e7;
		map[0x15e8]=0x10e8;
		map[0x15e9]=0x10e9;
		map[0x15ea]=0x10ea;
		map[0x15eb]=0x10eb;
		map[0x15ec]=0x10ec;
		map[0x15ed]=0x10ed;
		map[0x15ee]=0x10ee;
		map[0x15ef]=0x10ef;
		map[0x15f0]=0x10f0;
		map[0x15f1]=0x10f1;
		map[0x15f2]=0x10f2;
		map[0x15f3]=0x10f3;
		map[0x15f4]=0x10f4;
		map[0x15f5]=0x10f5;
		map[0x15f6]=0x10f6;
		map[0x12a1]=0x1e02;
		map[0x12a2]=0x1e03;
		map[0x12a6]=0x1e0a;
		map[0x12a8]=0x1e80;
		map[0x12aa]=0x1e82;
		map[0x12ab]=0x1e0b;
		map[0x12ac]=0x1ef2;
		map[0x12b0]=0x1e1e;
		map[0x12b1]=0x1e1f;
		map[0x12b4]=0x1e40;
		map[0x12b5]=0x1e41;
		map[0x12b7]=0x1e56;
		map[0x12b8]=0x1e81;
		map[0x12b9]=0x1e57;
		map[0x12ba]=0x1e83;
		map[0x12bb]=0x1e60;
		map[0x12bc]=0x1ef3;
		map[0x12bd]=0x1e84;
		map[0x12be]=0x1e85;
		map[0x12bf]=0x1e61;
		map[0x12d0]=0x0174;
		map[0x12d7]=0x1e6a;
		map[0x12de]=0x0176;
		map[0x12f0]=0x0175;
		map[0x12f7]=0x1e6b;
		map[0x12fe]=0x0177;
		map[0x0590]=0x06f0;
		map[0x0591]=0x06f1;
		map[0x0592]=0x06f2;
		map[0x0593]=0x06f3;
		map[0x0594]=0x06f4;
		map[0x0595]=0x06f5;
		map[0x0596]=0x06f6;
		map[0x0597]=0x06f7;
		map[0x0598]=0x06f8;
		map[0x0599]=0x06f9;
		map[0x05a5]=0x066a;
		map[0x05a6]=0x0670;
		map[0x05a7]=0x0679;
		map[0x05a8]=0x067e;
		map[0x05a9]=0x0686;
		map[0x05aa]=0x0688;
		map[0x05ab]=0x0691;
		map[0x05ae]=0x06d4;
		map[0x05b0]=0x0660;
		map[0x05b1]=0x0661;
		map[0x05b2]=0x0662;
		map[0x05b3]=0x0663;
		map[0x05b4]=0x0664;
		map[0x05b5]=0x0665;
		map[0x05b6]=0x0666;
		map[0x05b7]=0x0667;
		map[0x05b8]=0x0668;
		map[0x05b9]=0x0669;
		map[0x05f3]=0x0653;
		map[0x05f4]=0x0654;
		map[0x05f5]=0x0655;
		map[0x05f6]=0x0698;
		map[0x05f7]=0x06a4;
		map[0x05f8]=0x06a9;
		map[0x05f9]=0x06af;
		map[0x05fa]=0x06ba;
		map[0x05fb]=0x06be;
		map[0x05fc]=0x06cc;
		map[0x05fd]=0x06d2;
		map[0x05fe]=0x06c1;
		map[0x0680]=0x0492;
		map[0x0681]=0x0496;
		map[0x0682]=0x049a;
		map[0x0683]=0x049c;
		map[0x0684]=0x04a2;
		map[0x0685]=0x04ae;
		map[0x0686]=0x04b0;
		map[0x0687]=0x04b2;
		map[0x0688]=0x04b6;
		map[0x0689]=0x04b8;
		map[0x068a]=0x04ba;
		map[0x068c]=0x04d8;
		map[0x068d]=0x04e2;
		map[0x068e]=0x04e8;
		map[0x068f]=0x04ee;
		map[0x0690]=0x0493;
		map[0x0691]=0x0497;
		map[0x0692]=0x049b;
		map[0x0693]=0x049d;
		map[0x0694]=0x04a3;
		map[0x0695]=0x04af;
		map[0x0696]=0x04b1;
		map[0x0697]=0x04b3;
		map[0x0698]=0x04b7;
		map[0x0699]=0x04b9;
		map[0x069a]=0x04bb;
		map[0x069c]=0x04d9;
		map[0x069d]=0x04e3;
		map[0x069e]=0x04e9;
		map[0x069f]=0x04ef;
		map[0x16a2]=0x0000;
		map[0x16a3]=0x1e8a;
		map[0x16a5]=0x0000;
		map[0x16a6]=0x012c;
		map[0x16a7]=0x0000;
		map[0x16a8]=0x0000;
		map[0x16a9]=0x01b5;
		map[0x16aa]=0x01e6;
		map[0x16af]=0x019f;
		map[0x16b2]=0x0000;
		map[0x16b3]=0x1e8b;
		map[0x16b4]=0x0000;
		map[0x16b5]=0x0000;
		map[0x16b6]=0x012d;
		map[0x16b7]=0x0000;
		map[0x16b8]=0x0000;
		map[0x16b9]=0x01b6;
		map[0x16ba]=0x01e7;
		map[0x16bd]=0x01d2;
		map[0x16bf]=0x0275;
		map[0x16c6]=0x018f;
		map[0x16f6]=0x0259;
		map[0x16d1]=0x1e36;
		map[0x16d2]=0x0000;
		map[0x16d3]=0x0000;
		map[0x16e1]=0x1e37;
		map[0x16e2]=0x0000;
		map[0x16e3]=0x0000;
		map[0x1ea0]=0x1ea0;
		map[0x1ea1]=0x1ea1;
		map[0x1ea2]=0x1ea2;
		map[0x1ea3]=0x1ea3;
		map[0x1ea4]=0x1ea4;
		map[0x1ea5]=0x1ea5;
		map[0x1ea6]=0x1ea6;
		map[0x1ea7]=0x1ea7;
		map[0x1ea8]=0x1ea8;
		map[0x1ea9]=0x1ea9;
		map[0x1eaa]=0x1eaa;
		map[0x1eab]=0x1eab;
		map[0x1eac]=0x1eac;
		map[0x1ead]=0x1ead;
		map[0x1eae]=0x1eae;
		map[0x1eaf]=0x1eaf;
		map[0x1eb0]=0x1eb0;
		map[0x1eb1]=0x1eb1;
		map[0x1eb2]=0x1eb2;
		map[0x1eb3]=0x1eb3;
		map[0x1eb4]=0x1eb4;
		map[0x1eb5]=0x1eb5;
		map[0x1eb6]=0x1eb6;
		map[0x1eb7]=0x1eb7;
		map[0x1eb8]=0x1eb8;
		map[0x1eb9]=0x1eb9;
		map[0x1eba]=0x1eba;
		map[0x1ebb]=0x1ebb;
		map[0x1ebc]=0x1ebc;
		map[0x1ebd]=0x1ebd;
		map[0x1ebe]=0x1ebe;
		map[0x1ebf]=0x1ebf;
		map[0x1ec0]=0x1ec0;
		map[0x1ec1]=0x1ec1;
		map[0x1ec2]=0x1ec2;
		map[0x1ec3]=0x1ec3;
		map[0x1ec4]=0x1ec4;
		map[0x1ec5]=0x1ec5;
		map[0x1ec6]=0x1ec6;
		map[0x1ec7]=0x1ec7;
		map[0x1ec8]=0x1ec8;
		map[0x1ec9]=0x1ec9;
		map[0x1eca]=0x1eca;
		map[0x1ecb]=0x1ecb;
		map[0x1ecc]=0x1ecc;
		map[0x1ecd]=0x1ecd;
		map[0x1ece]=0x1ece;
		map[0x1ecf]=0x1ecf;
		map[0x1ed0]=0x1ed0;
		map[0x1ed1]=0x1ed1;
		map[0x1ed2]=0x1ed2;
		map[0x1ed3]=0x1ed3;
		map[0x1ed4]=0x1ed4;
		map[0x1ed5]=0x1ed5;
		map[0x1ed6]=0x1ed6;
		map[0x1ed7]=0x1ed7;
		map[0x1ed8]=0x1ed8;
		map[0x1ed9]=0x1ed9;
		map[0x1eda]=0x1eda;
		map[0x1edb]=0x1edb;
		map[0x1edc]=0x1edc;
		map[0x1edd]=0x1edd;
		map[0x1ede]=0x1ede;
		map[0x1edf]=0x1edf;
		map[0x1ee0]=0x1ee0;
		map[0x1ee1]=0x1ee1;
		map[0x1ee2]=0x1ee2;
		map[0x1ee3]=0x1ee3;
		map[0x1ee4]=0x1ee4;
		map[0x1ee5]=0x1ee5;
		map[0x1ee6]=0x1ee6;
		map[0x1ee7]=0x1ee7;
		map[0x1ee8]=0x1ee8;
		map[0x1ee9]=0x1ee9;
		map[0x1eea]=0x1eea;
		map[0x1eeb]=0x1eeb;
		map[0x1eec]=0x1eec;
		map[0x1eed]=0x1eed;
		map[0x1eee]=0x1eee;
		map[0x1eef]=0x1eef;
		map[0x1ef0]=0x1ef0;
		map[0x1ef1]=0x1ef1;
		map[0x1ef4]=0x1ef4;
		map[0x1ef5]=0x1ef5;
		map[0x1ef6]=0x1ef6;
		map[0x1ef7]=0x1ef7;
		map[0x1ef8]=0x1ef8;
		map[0x1ef9]=0x1ef9;
		map[0x1efa]=0x01a0;
		map[0x1efb]=0x01a1;
		map[0x1efc]=0x01af;
		map[0x1efd]=0x01b0;
		map[0x1e9f]=0x0303;
		map[0x1ef2]=0x0300;
		map[0x1ef3]=0x0301;
		map[0x1efe]=0x0309;
		map[0x1eff]=0x0323;
		map[0xfe60]=0x0323;
		map[0xfe61]=0x0309;
		map[0xfe62]=0x031b;

		buildUp=true;
		}
	return map[keysym];
	};

};

#endif /* KEYMAP_H_ */
