/***************************************************************************
 *   Copyright (C) 2009 by Kai Dombrowe <just89@gmx.de>                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef GAMEMODEL_H
#define GAMEMODEL_H

/// Qt
#include <QAbstractItemModel>
#include <QModelIndex>
#include <QVariant>


class GameItem;
class GameModel : public QAbstractItemModel
{
	Q_OBJECT


public:
	GameModel( QObject *parent = 0 );
	~GameModel();


public slots:
	QVariant data( const QModelIndex &index, int role ) const;
	Qt::ItemFlags flags( const QModelIndex &index ) const;
	QModelIndex index( int row, int column, const QModelIndex &parent = QModelIndex() ) const;
	QModelIndex parent( const QModelIndex &index ) const;
	int rowCount( const QModelIndex &parent = QModelIndex() ) const;
	int columnCount( const QModelIndex &parent = QModelIndex() ) const{ Q_UNUSED( parent ); return 1; };
	void addGame( const QString& name, const QString& icon, const QString& cmd, const bool& startx );
	QString icon( int row, int column, const QModelIndex &parent );
	QList<GameItem*> gameList(){ return items; };
	void removeItem(  int row, int column, const QModelIndex &parent );
	GameItem* item(  int row, int column, const QModelIndex &parent );
	void insertItem( GameItem *item, const int& row );
	GameItem* parentGame(){ return parentItem; };
	void removeGame( GameItem *game );


private slots:
	void qUpdate();


private:
	void setupModelData( const QStringList &lines, GameItem *parent );
	QList<GameItem*> items;
	GameItem *parentItem;

    
};

 #endif