/***************************************************************************
 *   Copyright (C) 2009 by Kai Dombrowe <just89@gmx.de>                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

/// Qt
#include <QStringList>

/// own
#include "gameitem.h"



GameItem::GameItem(  const QString& n, const QString& i, GameItem *parent )
	: _name( n ),
	_icon( i ),
	_startx( false )
{

	parentItem = parent;
 
}


GameItem::~GameItem()
{

     qDeleteAll( childItems );

}


void GameItem::appendChild( GameItem *item )
{

	childItems.append( item );

}


GameItem *GameItem::child( int row )
{

	return childItems.value( row );

}


int GameItem::childCount() const
{

	return childItems.count();

}


int GameItem::columnCount() const
{

	return 0;

}


QVariant GameItem::data( const int& role ) const
{

	if( role == 1 )
		return _icon;
	else
		return _name;

}


GameItem *GameItem::parent()
{

	return parentItem;

}


int GameItem::row() const
{
	if( parentItem )
		return parentItem->childItems.indexOf( const_cast<GameItem*>( this ) );

	return 0;
 
}


QString GameItem::icon() const
{

	return _icon;

}


QString GameItem::cmd() const
{

	return _cmd;

}


bool GameItem::startx() const
{

	return _startx;

}


void GameItem::setName( const QString& newName )
{

	if( newName == _name )
		return;

	_name = newName;
	emit needUpdate();

}


void GameItem::setIcon( const QString& newIcon )
{

	_icon = newIcon;
	emit needUpdate();

}


void GameItem::setCmd( const QString& newCmd )
{

	if( newCmd == _cmd )
		return;

	_cmd = newCmd;
	emit needUpdate();

}


void GameItem::setStartx( const bool& newStartx )
{

	if( newStartx == _startx )
		return;

	_startx = newStartx;
	emit needUpdate();

}
