/*
 *      pop.cpp
 *
 *      Copyright 2009 Sebastian Wankerl <far_away@online.de>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */


# include "pop.hpp"

pop3::pop3 (const std::string &u, const std::string &pw, const std::string &server)  :  base_io(u, pw, server, 110)
{
    user = u;
    password = pw;
}

pop3::~pop3 () {
    result = close (st);
    if (result == 1)
        throw std::runtime_error ("close () failed");
}

int pop3::start () {
    std::string request;
    int counter = 0;
    for (int i = 0; i < 4; ++i) {
        int temp = recieve(i==3);
        counter = temp > 0 ? temp : counter;

        switch (i) {
            case 0: request = "USER " + user; break;
            case 1: request = "PASS " + password; break;
            case 2: request = "STAT"; break;
            case 3: request = "QUIT"; break;
        }
        request += "\r\n";
        send_request (request);
    }
    return counter;
}

int pop3::recieve (bool read) {
    std::stringstream line;
    int unred_mails = 0;
    for (char c; recv (st, &c, 1, 0) > 0; line << c) {
	if (c == '\n') {
	    if (line.str().find("-ERR") != std::string::npos)
		throw std::runtime_error ("Access denied");
            if (read)
                unred_mails = procedure_string (line.str ());

	    return unred_mails;
	}
    }
    return 0;
}

int pop3::procedure_string (std::string str) {
    int counter = 0;
    unsigned index = str.find (" ");
    if (index != std::string::npos) {
        std::string count_str = str.substr (index + 1, str.find (" ", index+1) - (index+1));
        counter = std::atoi(count_str.c_str());
    }
    return counter;
}
