/*
 *      plasmoid.hpp
 *
 *      Copyright 2009 Sebastian Wankerl <far_away@online.de>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */


#ifndef MPL_HEADER
#define MPL_HEADER

#include <KIcon>
#include <KDialog>
#include <KConfig>
#include <Plasma/Applet>
#include <Plasma/Svg>

#include "thread.hpp"
#include "ui_untitled.h"

class QSizeF;

class MailWidget1 : public Plasma::Applet
{
    Q_OBJECT
    public:
    MailWidget1(QObject *parent, const QVariantList &args);
    ~MailWidget1();

    void paintInterface(QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect& contentsRect);
    void init();

    protected:
    void createConfigurationInterface(KConfigDialog *parent);

    private:
    KConfig conf;
    KConfigGroup general_group;
    Plasma::Svg m_svg;
    KIcon icon, icon_new, error_icon;
    threadu *thrd;
    int mails;
    KConfigDialog *dlg;
    Ui::Config my_ui;

    private slots:
    void update_plasmoid (int);
    void changeConfig();
};

// This is the command that links your applet to the .desktop file
K_EXPORT_PLASMA_APPLET(mail_plasmoid, MailWidget1)

#endif
