/*
 *      base_io.hpp
 *
 *      Copyright 2009 Sebastian Wankerl <far_away@online.de>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */


#ifndef BASE_IO
#define BASE_IO

# include <sstream>
# include <string>
# include <stdexcept>
# include <cstdlib>

# include <sys/socket.h>
# include <arpa/inet.h>
# include <netdb.h>
# include <errno.h>
# include <fcntl.h>
# include <signal.h>

class base_io {
    public:
    base_io(const std::string&, const std::string&, const std::string&, int);
    virtual ~base_io();

    virtual int start () = 0;

    protected:
    void send_request (const std::string&);
    virtual int recieve (bool) = 0;
    virtual int procedure_string (std::string) = 0;

    int st; // the socket
    sockaddr_in service;
    int result;
    std::string user, password;
};

#endif
