/*
 *      base_io.cpp
 *
 *      Copyright 2009 Sebastian Wankerl <far_away@online.de>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */


#include "base_io.hpp"

base_io::base_io (const std::string &u, const std::string &pw, const std::string &server, int port)  :  user (u),
													password (pw)
{
    signal(SIGPIPE, SIG_IGN);

    st = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (st == -1)
        throw std::runtime_error ("socket () failed");

    service.sin_family = AF_INET;
    service.sin_port = htons (port);
    service.sin_family = AF_INET;

    hostent *host = gethostbyname (server.c_str ());
    if (host == 0)
        throw std::runtime_error ("Couldn't connect to the server");

    char **p = host->h_addr_list;
    do {
        if(*p == 0)
            throw std::runtime_error ("Couldn't connect to the server");;

        service.sin_addr.s_addr = *reinterpret_cast<unsigned long*>(*p);
        ++p;
        result = connect(st, reinterpret_cast<sockaddr*>(&service), sizeof(service));
    }
    while(result == -1);
}

base_io::~base_io () {
    result = close (st);
    if (result == 1)
        throw std::runtime_error ("close () failed");
}

void base_io::send_request (const std::string &m) {
    unsigned sent = 0;
    const char *msg = m.c_str ();
    const unsigned size = m.size ();

    do {
        result = send (st, msg + sent, size - sent, 0);
        if (result < 0)
            throw std::runtime_error ("send () failed");
        sent += result;
    } while (sent < size);
}
