/********************************************************************************
 *   Copyright (C) 2008-2009 by Bram Schoenmakers <bramschoenmakers@kde.nl>     *
 *                                                                              *
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by       *
 *   the Free Software Foundation; either version 2 of the License, or          *
 *   (at your option) any later version.                                        *
 *                                                                              *
 *   This program is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *   GNU General Public License for more details.                               *
 *                                                                              *
 *   You should have received a copy of the GNU General Public License          *
 *   along with this program; if not, write to the                              *
 *   Free Software Foundation, Inc.,                                            *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .             *
 ********************************************************************************/

#include <QGroupBox>
#include <QLabel>
#include <QVBoxLayout>

#include <KComboBox>
#include <KLocale>

#include "marbledialog.h"

MarbleDialog::MarbleDialog( QWidget *p_parent )
: LocationDialog( p_parent )
{
  QGroupBox *group = new QGroupBox( i18n("Select a location:" ), this );
  QHBoxLayout *hlayout = new QHBoxLayout( group );
  QVBoxLayout *vlayout = new QVBoxLayout( group );

  m_marbleWidget = new Marble::MarbleWidget( group );
  m_marbleWidget->setMapThemeId( "earth/plain/plain.dgml" );

  m_marbleControl = new Marble::MarbleControlBox( group );
  m_marbleControl->addMarbleWidget( m_marbleWidget );

  hlayout->addWidget( m_marbleControl, 0 );
  vlayout->addWidget( m_marbleWidget, 1 );

  QHBoxLayout *hlayout2 = new QHBoxLayout( group );

  QLabel *label = new QLabel( i18n( "Accuracy:" ), group );
  label->setBuddy( m_accuracyCombo );
  hlayout2->addWidget( label, 0 );

  hlayout2->addWidget( m_accuracyCombo, 1 );
  
  vlayout->addLayout( hlayout2, 0 );
  hlayout->addLayout( vlayout, 1 );

  setMainWidget( group );

  setInitialSize( QSize( 800, 600 ) );
  setButtons( KDialog::Ok | KDialog::Cancel );

  setZoom( 1337 );
}

MarbleDialog::~MarbleDialog()
{
}

void MarbleDialog::setLongitude( qreal p_longitude )
{
  return m_marbleWidget->setCenterLongitude( p_longitude );
}

void MarbleDialog::setLatitude( qreal p_latitude )
{
  return m_marbleWidget->setCenterLatitude( p_latitude );
}

qreal MarbleDialog::getLongitude() const
{
  return m_marbleWidget->centerLongitude();
}

qreal MarbleDialog::getLatitude() const
{
  return m_marbleWidget->centerLatitude();
}

void MarbleDialog::setZoom( int p_zoomLevel )
{
  m_marbleWidget->zoomView( p_zoomLevel );
}

