/********************************************************************************
 *   Copyright (C) 2008-2009 by Bram Schoenmakers <bramschoenmakers@kde.nl>     *
 *                                                                              *
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by       *
 *   the Free Software Foundation; either version 2 of the License, or          *
 *   (at your option) any later version.                                        *
 *                                                                              *
 *   This program is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *   GNU General Public License for more details.                               *
 *                                                                              *
 *   You should have received a copy of the GNU General Public License          *
 *   along with this program; if not, write to the                              *
 *   Free Software Foundation, Inc.,                                            *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .             *
 ********************************************************************************/

#ifndef FLICKR_OP_H
#define FLICKR_OP_H

#include <QPixmap>
#include <QPointer>

#include <Plasma/Applet>
#include <Plasma/DataEngine>

#include "ui_generalsettings.h"
#include "ui_streamsettings.h"
#include "ui_authenticationsettings.h"

#include "../engine/types.h"

class KConfigDialog;

class ClusterDialog;
class PhotosetDialog;
class LocationDialog;

class FlickrOP : public Plasma::Applet
{
  Q_OBJECT
public:
  FlickrOP( QObject* p_parent, const QVariantList& p_args );
  ~FlickrOP();

protected:
  QList<QAction *> contextualActions();
  void createConfigurationInterface( KConfigDialog *p_parent );
  void setupWidgets();
  void init();
  void paintCache( const QStyleOptionGraphicsItem *p_option, const QRect &p_contentsRect );
  void paintInterface ( QPainter *p_painter, const QStyleOptionGraphicsItem *p_option, const QRect &p_contentsRect );
  void sendConfigurationToEngine();
  void setSize( const QString &p_size );

protected slots:
  void authenticate();
  void clusterChosen();
  void getClusters();
  void getPhotosets();
  void locationChosen();
  void markAsFavorite();
  void nextPhoto();
  void photosetChosen();
  void photosetUserChanged( const QString &p_username );
  void photosetUserEdited( const QString &p_username );
  void radioChanged();
  void readConfig();
  void setOkButton();
  void showClusterDialog();
  void showErrorBox( const QString &p_message );
  void showMarbleDialog();
  void showPhotosetDialog();
  void tagTextChanged( const QString &p_tag );
  void tagTextEdited( const QString &p_tag );
  void visitAuthor();
  void visitAuthorPhotos();
  void visitPhoto();
  void writeConfig();

public slots:
  void dataUpdated( const QString &p_sourceName, const Plasma::DataEngine::Data &p_data );

private:
  QPixmap createMask( const QSize &p_size );
private:
  // contains some data about the currently shown photo
  Photo m_photo;
  QString m_error;
  QPixmap m_pixmapPhoto;
  QPixmap m_pixmapCache;
  QList<QAction *> m_actions;
  Plasma::DataEngine *m_engine;
  bool m_authenticated;
  bool m_cluster_chosen;
  bool m_tag_edited;
  bool m_photoset_chosen;
  bool m_location_chosen;
  QString m_nsid;
  QPointer<ClusterDialog> m_clusterdialog;
  QPointer<PhotosetDialog> m_photosetdialog;
  QPointer<LocationDialog> m_locationdialog;

  // configuration pages
  Ui::GeneralWidget *m_general_page;
  Ui::StreamWidget *m_stream_page;
  Ui::AuthenticationWidget *m_authentication_page;

  // actions which require authorization
  QAction *m_markFavorite;
  QAction *m_nextPhoto;
  QAction *m_visitAuthor;
  QAction *m_visitPhotoPage;
  QAction *m_visitAuthorPhotos;

  // widgets
  KConfigDialog *m_config_dialog;

  // preferences
  Plasma::DataEngine::Data m_config;
  bool m_show_author;
  bool m_round_corners;
  bool m_show_background;
  bool m_soft_borders;
  QFont m_author_font;
  QColor m_author_color;
  int m_font_height;
};

#endif // FLICKR_OP_H
