
/* Copyright 2009  Jan Gerrit Marker <jangerrit@weiler-marker.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//Header-File of the Runner
#ifndef KRUNNERTEST_H
#define KRUNNERTEST_H

#include <plasma/abstractrunner.h>
#include <KIcon>

// Define our plasma Runner
class AmarokRunner : public Plasma::AbstractRunner
{
    Q_OBJECT

public:
    AmarokRunner(QObject *parent, const QVariantList& args);
    ~AmarokRunner();

    void match(Plasma::RunnerContext &context);
    void run(const Plasma::RunnerContext &context, const Plasma::QueryMatch &match);
    void reloadConfiguration();

private:
    Qt::CaseSensitivity val_caseSens;
    bool noprefix;
    bool searchPlaylist;
    QString prefix;
    QString com_play;
    QString com_pause;
    QString com_next;
    QString com_mute;
    QString com_up;
    int val_up;
    QString com_down;
    int val_down;
    QString com_prev;
    QString com_stop;
    QString com_volume;
    QString com_quit;

    bool searching;

    /** Extracts the number out of the command.
      * @param command is the command
      * @param separator is the separator
      * @return the number
      */
    QString getNumberAsText(const QString &command, const QChar &separator);
    /** Tests if str2 contains str1. It uses the variable val_caseSens
      * to look if it should be case sensitive. It's good for command
      * checking as in KRunner.
      */
    bool equals(const QString &str1, const QString &str2);
    /** Tests if str matches exp. It uses the variable val_caseSens
      * to look if it should be case sensitive. It's good for command
      * checking as in KRunner.
      */
    bool equals(const QString& str, QRegExp exp);
    /** Tests if str1 equals str2. It uses the variable val_caseSens
      * to look if it should be case sensitive.
      */
    bool equalsComplete(const QString &str1, const QString &str2);

    bool startAmarok();
    bool interfaceAvailable(const QString&, const QString&);
    void addMatch(Plasma::RunnerContext&, AmarokRunner*, const QString&, const QString&, const KIcon&, const QStringList&, const float&);
    void addMatch(Plasma::RunnerContext&, AmarokRunner*, const QString&, const QString&, const QString&, const KIcon&, const QStringList&, const float&);
    QList<QVariantMap > findSongs(const QString&);
    bool trackMatchs(const QVariantMap&, const QString&);
    bool amarokRunning();
    bool playlistEmpty();
    /** Returns the number of the songs in the playlist*/
    int songsInPlaylist();
    bool nextSongAvailable();
    bool prevSongAvailable();
    /** Returns the number of the current song*/
    int currentSong();
};

// This is the command that links your applet to the .desktop file
K_EXPORT_PLASMA_RUNNER(amarokrunner, AmarokRunner)

#endif
