/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "kbfxspinxtoolbutton.h"
#include <kbfxplasmaskinmanager.h>
#include <qpainter.h>
#include <QtGui/QPaintEvent>
#include <qcursor.h>
#include <kiconloader.h>

KbfxSpinxToolButton::KbfxSpinxToolButton ( QWidget * parent , const char * name ) :QLabel ( parent,name,Qt::WStaticContents | Qt::WNoAutoErase |Qt::WPaintDesktop )
{
	m_dataSource = 0;
	m_dataGroup  = 0;
//	 m_current = QPixmap(KbfxPlasmaSkinManager::
//	     getThemePixmapPath (KbfxPlasmaSkinManager::LOGOUT));

}


KbfxSpinxToolButton::~KbfxSpinxToolButton()
{}
/*
void
KbfxSpinxToolButton::setBackground(QPixmap pixmap)
{

}
*/

void
KbfxSpinxToolButton::enterEvent ( QEvent * e )
{
	e = e;
	m_current   = m_hover;;
	this->update();
	this->setCursor ( QCursor ( Qt::PointingHandCursor ) );
}

void
KbfxSpinxToolButton::leaveEvent ( QEvent * e )
{
	e = e;
	m_current = m_normal;
	this->update();
	this->setCursor ( QCursor ( Qt::ArrowCursor ) );
}

void
KbfxSpinxToolButton::setPixmaps ( QPixmap normal, QPixmap hover )
{

	m_normal = normal;
	m_hover = hover;
	m_current = m_normal;

	resize ( m_current.width(),m_current.height() );
	this->repaint();
	this->update();
}


void
KbfxSpinxToolButton::setDataSource ( KbfxDataSource * src )
{
	m_name = src->name();
	m_icon = src->icon();
	m_exe = src->command();
	m_dataSource = new KbfxDataSource();
	*m_dataSource  = *src; //copy
	QString m_iconPath =  KIconLoader().iconPath ( m_icon, K3Icon::Desktop, false );
	m_iconPixmap = QPixmap ( m_iconPath );
}

void
KbfxSpinxToolButton::paintEvent ( QPaintEvent * e )
{
	QRect r = e->rect();
	QPainter p;
	static QPixmap buffer ( m_current.width(),m_current.height() );
	buffer.fill();
	p.begin ( this );
	p.setPen ( QColor ( 255,255,255 ) );
	p.drawPixmap ( QRect ( 0,0,m_current.width(),m_current.height() ),m_current );
	//p.drawPixmap(QRect(5,5,32,32),m_iconPixmap);
	//p.drawRect(QRect(0,0,,48));
	p.end();
//	QPainter pw;
//	pw.begin(this);
//	pw.drawPixmap(QRect(0,0,m_current.width(),m_current.height()),buffer);
//	pw.end();
}


void
KbfxSpinxToolButton::mouseReleaseEvent ( QMouseEvent * me )
{
	me = me;
	if ( m_dataSource == 0 )
		return;
	else
		KRun::runCommand ( m_dataSource->command(), 0 );

	emit clicked();

}
#include "kbfxspinxtoolbutton.moc"
