/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "kbfxspinxmenu.h"
#include <qapplication.h>
#include "kbfxspinxview.h"
#include "kbfxsignal.h"
#include "kbfxspinxscrollbar.h"
#include <qlineedit.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qbitmap.h>
//#include <kbfxplasmaskinmanager.h>
#include "kbfxplasmapixmapprovider.h"
#include "kbfxspinxtoolbutton.h"




KbfxSpinxMenuWidget::KbfxSpinxMenuWidget ( QWidget * parent, const char *name,
        Qt::WindowFlags fl ) :
		QWidget ( parent,
		          fl |  Qt::WStyle_Customize | Qt::WStyle_NoBorder | Qt::WStyle_StaysOnTop )
{
	m_parent = parent;

	createMask ();

	QWidget *main = new QWidget ( this );

	m_kbfxSpinxTop = new KbfxSpinxTop ( main );
	m_toolBarBot = new KbfxSpinxToolBar ( main );
	m_toolBarBot->setMinimumHeight ( ConfigInit ().m_botBar_h );
	m_toolBarBot->setMaximumHeight ( ConfigInit ().m_botBar_h );
	m_kbfxSpinxTop->setMaximumHeight ( ConfigInit ().m_topBar_h );

	QWidget *middle = new QWidget ( main );

	middle->setPalette ( QPalette ( QColor ( 24, 233, 233 ) ) );

// m_middleFrame = new QHBoxLayout(middle);

	m_canvasView = new KbfxPlasmaCanvasView ( this );
	m_indexView = new KbfxPlasmaIndexView ( this );
	m_indexLeftView = new KbfxPlasmaIndexView ( this );

	/* Search Box */
	m_searchTag = new KbfxPixmapLabel ( this, "Search:" );
	m_searchTag->normalize ();
	m_searchTag->move ( ConfigInit ().m_searchBox_x,
	                    ConfigInit ().m_searchBox_y );

/*
	QPixmap m_searchPixmap = QPixmap ( KbfxPlasmaSkinManager::
	                                   getThemePixmapPath
	                                   ( KbfxPlasmaSkinManager::FIND ) );

*/

	QPixmap m_searchPixmap = ( *KbfxPlasmaPixmapProvider::pixmap ( "find" ) );

	m_searchTag->setPixmap ( m_searchPixmap );

	m_searchTag->resize ( m_searchPixmap.width (), ConfigInit ().m_searchBox_h );

	m_search = new QLineEdit ( this, "Search BOX" );
	m_search->setFocusPolicy ( Qt::ClickFocus );
	m_search->move ( ConfigInit ().m_searchBox_x + m_searchTag->width (),
	                 ConfigInit ().m_searchBox_y );
	m_search->resize ( ConfigInit ().m_searchBox_w - m_searchTag->width (),
	                   ConfigInit ().m_searchBox_h );

	connect (m_searchTag, SIGNAL (mouseDoubleClicked ( const ButtonState & )), this, SLOT (search_clear ( const ButtonState & )));


	int frameHeight =
	    this->height () - ( m_kbfxSpinxTop->height () + m_toolBarBot->height () );
// m_middleFrame->addWidget(middleleft);
	m_canvasView->setMaximumHeight ( frameHeight );
	m_canvasView->setMinimumHeight ( frameHeight );
	m_canvasView->setMaximumWidth ( ConfigInit ().m_itemView_w );
	m_canvasView->setMinimumWidth ( ConfigInit ().m_itemView_w );
	m_appCanvas = new Q3Canvas ( m_canvasView->width (), m_canvasView->height () );
	m_canvasView->setKbfxCanvas ( m_appCanvas );
	m_appCanvas->setDoubleBuffering ( true );

	m_indexView->setMaximumHeight ( frameHeight );
	m_indexView->setMinimumHeight ( frameHeight );
	m_indexView->setMaximumWidth ( ConfigInit ().m_listBox_w );
	m_indexView->setMinimumWidth ( ConfigInit ().m_listBox_w );
	m_indexCanvas = new Q3Canvas ( m_indexView->width (), m_indexView->height () );
	m_indexView->setKbfxCanvas ( m_indexCanvas );
	m_indexCanvas->setDoubleBuffering ( true );
	m_indexView->setView ( m_canvasView );

	m_indexLeftView->setMaximumHeight ( frameHeight );
	m_indexLeftView->setMinimumHeight ( frameHeight );
	m_indexLeftView->setMaximumWidth ( ConfigInit ().m_listBox_w );
	m_indexLeftView->setMinimumWidth ( ConfigInit ().m_listBox_w );
	m_indexLeftCanvas =
	    new Q3Canvas ( m_indexLeftView->width (), m_indexLeftView->height () );
	m_indexLeftView->setKbfxCanvas ( m_indexLeftCanvas );
	m_indexLeftCanvas->setDoubleBuffering ( true );
	m_indexLeftView->setView ( m_canvasView );


	m_canvasView->move ( ConfigInit ().m_itemView_x, ConfigInit ().m_itemView_y );
	m_indexView->move ( ConfigInit ().m_listBox_x, ConfigInit ().m_listBox_y );
	m_indexLeftView->move ( m_canvasView->width () + m_indexView->width (),
	                        ConfigInit ().m_listBox_y );


	m_fixedFrame = new QVBoxLayout ( main );
	m_fixedFrame->setResizeMode ( QLayout::Minimum );
	m_fixedFrame->addWidget ( m_kbfxSpinxTop );
	m_fixedFrame->addWidget ( middle );
	m_fixedFrame->addWidget ( m_toolBarBot );


	m_loadedList = " ";
	main->resize ( this->size () );
	loadHistory ();

	connect ( m_indexView, SIGNAL ( loadRequest ( KbfxSignal ) ), m_canvasView,
	          SLOT ( handleLoadRequest ( KbfxSignal ) ) );

	connect ( m_indexLeftView, SIGNAL ( loadRequest ( KbfxSignal ) ), m_canvasView,
	          SLOT ( handleLoadRequest ( KbfxSignal ) ) );

	connect ( m_canvasView, SIGNAL ( clicked () ), this, SLOT ( hideMenu () ) );

	connect ( m_search, SIGNAL ( textChanged ( const QString & ) ), m_canvasView,
	          SLOT ( search ( const QString & ) ) );

	connect ( m_indexView,
	          SIGNAL ( pluginRequest ( QString, KbfxPlasmaCanvasView * ) ),
	          m_indexView, SLOT ( loadPlugin ( QString, KbfxPlasmaCanvasView * ) ) );

	connect ( m_indexLeftView,
	          SIGNAL ( pluginRequest ( QString, KbfxPlasmaCanvasView * ) ),
	          m_indexLeftView,
	          SLOT ( loadPlugin ( QString, KbfxPlasmaCanvasView * ) ) );

/*
	connect ( m_indexView,
	          SIGNAL ( expand() ),
	          m_canvasView, SLOT ( expandAll() ) );

	connect ( m_indexLeftView,
	          SIGNAL ( expand() ),
	          m_canvasView,
	          SLOT ( expandAll() ) );
*/


	KbfxSpinxToolButton *logout = new KbfxSpinxToolButton ( m_toolBarBot );
	KbfxSpinxToolButton *lock = new KbfxSpinxToolButton ( m_toolBarBot );

/*
	lock ->setPixmaps ( QPixmap ( KbfxPlasmaSkinManager::
	                              getThemePixmapPath ( KbfxPlasmaSkinManager::
	                                                   LOCK ) ),
	                    QPixmap ( KbfxPlasmaSkinManager::
	                              getThemePixmapPath ( KbfxPlasmaSkinManager::
	                                                   LOCKHOVER ) ) );

	logout->setPixmaps ( QPixmap ( KbfxPlasmaSkinManager::
	                               getThemePixmapPath ( KbfxPlasmaSkinManager::
	                                                    LOGOUT ) ),
	                     QPixmap ( KbfxPlasmaSkinManager::
	                               getThemePixmapPath ( KbfxPlasmaSkinManager::
	                                                    LOGOUTHOVER ) ) );
*/

	lock ->setPixmaps ( ( *KbfxPlasmaPixmapProvider::pixmap ( "lock" ) ),
						( *KbfxPlasmaPixmapProvider::pixmap ( "lockhover" ) ) );

	logout ->setPixmaps ( ( *KbfxPlasmaPixmapProvider::pixmap ( "logout" ) ),
						  ( *KbfxPlasmaPixmapProvider::pixmap ( "logouthover" ) ) );

	KbfxDataSource *logoutSrc = new KbfxDataSource ();
	logoutSrc->setCommand ( "dcop kdesktop KDesktopIface logout" );
	logoutSrc->setName ( "Logout" );

	KbfxDataSource *lockSrc = new KbfxDataSource ();
	lockSrc->setCommand ( "dcop kdesktop KScreensaverIface lock" );
	lockSrc->setName ( "logout" );

	logout->setDataSource ( logoutSrc );
	lock ->setDataSource ( lockSrc );

	delete logoutSrc;
	delete lockSrc;
	m_toolBarBot->addButton ( logout );
	m_toolBarBot->addButton ( lock );

	connect ( logout,SIGNAL ( clicked() ),this , SLOT ( hideMenu() ) );
	connect ( lock ,SIGNAL ( clicked() ),this , SLOT ( hideMenu() ) );


}

void
KbfxSpinxMenuWidget::search_clear ( Qt::MouseButton _btn )
{
	if ( _btn == Qt::LeftButton )
	{
		/* Clear the search box */
		m_search->clear();
		/* Clear the search canvas */
		m_canvasView->clearAll ();
	}
}

/*
void
KbfxSpinxMenuWidget::changeHeight (int het)
{

}
*/

void
KbfxSpinxMenuWidget::createMask ()
{
/*
	QPixmap maskpng = QPixmap ( KbfxPlasmaSkinManager::
	                            getThemePixmapPath ( KbfxPlasmaSkinManager::
	                                                 MASK ) );
*/
	QPixmap maskpng = ( *KbfxPlasmaPixmapProvider::pixmap ( "mask" ) );
	QImage rawimg = maskpng.convertToImage ();

	rawimg =
	    rawimg.smoothScale ( ConfigInit ().m_userMenuWidth,
	                   ConfigInit ().m_userMenuHeight );

	maskpng.convertFromImage ( rawimg );

	setMinimumWidth ( maskpng.width () );
	setMinimumHeight ( maskpng.height () );
	if ( !maskpng.mask () )
		if ( rawimg.hasAlphaBuffer () )
		{
			QBitmap bm;
			bm = rawimg.createAlphaMask ();
			maskpng.setMask ( bm );
		}
		else
		{
			QBitmap bm;
			bm = rawimg.createHeuristicMask ();
		//	maskpng.setMask ( bm );
		}

	if ( !maskpng.mask ().isNull() && m_parent )
		m_parent->setMask ( maskpng.mask () );

}


KbfxSpinxMenuWidget::~KbfxSpinxMenuWidget ()
{

	delete  m_fixedFrame;
//	delete  m_middleFrame;
	delete  m_appCanvas;
	delete  m_indexCanvas;
	delete  m_indexLeftCanvas;

	delete  m_indexView;

	delete  m_indexLeftView;
	delete  m_kbfxSpinxTop;
	delete  m_canvasView;

}

void
KbfxSpinxMenuWidget::resizeContent ()
{}


void
KbfxSpinxMenuWidget::loadHistory ()
{
	QStringList::Iterator it;
	for ( it = ConfigInit ().m_pluginsLeft.begin ();
	        it != ConfigInit ().m_pluginsLeft.end (); ++it )
	{
		this->loadPluginLeft ( ( *it ) );
	}
	for ( it = ConfigInit ().m_pluginsRight.begin ();
	        it != ConfigInit ().m_pluginsRight.end (); ++it )
	{
		this->loadPluginRight ( ( *it ) );
	}
}

void
KbfxSpinxMenuWidget::enterPressed ()
{
	qDebug ( "TODO: Implement Enter Presed" );
}
/*
void
KbfxSpinxMenuWidget::propergateMove (QMouseEvent * me)
{
}
*/

void
KbfxSpinxMenuWidget::hideMenu ()
{
	emit nowHidden ();
	m_parent->hide ();
}

/*
void
KbfxSpinxMenuWidget::mouseMoveEvent (QMouseEvent * me)
{
//      m_listBox->setFocus();

}
*/

void
KbfxSpinxMenuWidget::loadPluginLeft ( QString name )
{

	if ( m_loadedList.contains ( name ) <= 0 )
	{
		m_loadedList += name;
		m_loader = new KbfxPlasmaPluginLoader ();
		m_stack_R = m_loader->getView ( name );

		if ( m_stack_R == NULL )
			return;

		m_canvasView->addStack ( m_stack_R, name );


		m_indexView->loadList ( m_stack_R );
		delete m_loader;
		return;

	}
	else
	{
		qDebug ( "Already Loaded" );
		return;
	}


}



void
KbfxSpinxMenuWidget::loadPluginRight ( QString name )
{

	if ( m_loadedList.contains ( name ) <= 0 )
	{
		m_loadedList += name;
		m_loader = new KbfxPlasmaPluginLoader ();
		m_stack_R = m_loader->getView ( name );

		if ( m_stack_R == NULL )
			return;

		m_canvasView->addStack ( m_stack_R, name );


		m_indexLeftView->loadList ( m_stack_R );
		delete m_loader;
		return;

	}
	else
	{
		qDebug ( "Already Loaded" );
		return;
	}


}

/*
void
KbfxSpinxMenuWidget::focusInEvent (QFocusEvent * te)
{
  qDebug ("TODO: Handle Focus Event");
}
*/



void
KbfxSpinxMenuWidget::keyPressEvent ( QKeyEvent * e )
{
	if ( e->key () == Qt::Key_Backspace )
	{
		m_search->backspace ();
		return;
	}
	else if ( e->key () == Qt::Key_Escape )
	{
		this->hideMenu ();
		return;
	}
	else if ( e->key () == Qt::Key_Return )
	{
		hideMenu ();
		m_canvasView->setFocus ();
		emit runItem ();
		return;
	}
	else if ( e->key () == Qt::Key_Control )
	{
		return;
	}
	if ( e->key () == Qt::Key_Alt )
	{

//		m_search->clear ();
		return;
	}
	else if ( e->key () == Qt::Key_Tab )
	{
		//m_listBox->setFocus ();
		return;
	}
	if ( e->key () >= Qt::Key_0 && e->key () <= Qt::Key_9 )
	{
		printf ( "%d \n", e->key () );
		emit runItemAt ( e->key () );
		return;
	}
	if ( e->key () == Qt::Key_Up )
	{
		m_search->setFocus ();
		return;
	}
	if ( e->key () == Qt::Key_Down )
	{
		m_canvasView->setFocus ();
		return;
	}
	if ( e->key () == Qt::Key_Left )
	{
		m_canvasView->setFocus ();
		m_canvasView->emulatedKeyPress ( e );
		return;
	}

	m_search->show ();
	//      m_listBox->move(0,22+m_menuTop->height());
	m_search->setText ( m_search->text () + e->text () );

}

#include "kbfxspinxmenu.moc"
