/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_SPINX_H
#define KBFX_SPINX_H

#include <plasma/kpanelapplet.h>
#include <qstring.h>
#include <kconfig.h>
#include <qpoint.h>
#include <qtimer.h>
#include <kdebug.h>
#include <kbfxconfig.h>

#include "kbfxbutton.h"
#include "kbfxspinxpopup.h"
#include "kbfxspinxmenu.h"


class KbfxSpinx : public KPanelApplet
{
		Q_OBJECT

	public:

		KbfxSpinx ( const QString& configFile, Plasma::Type t = Plasma::Normal, int actions = 0,
		            QWidget *parent = 0 );

		~KbfxSpinx();
		virtual int widthForHeight ( int height ) const;
		virtual int heightForWidth ( int width ) const;
		virtual void about();
		virtual void help();
		virtual void preferences();
		virtual  bool 	eventFilter ( QObject *o, QEvent *e );
		QPoint menuPosition();
		void reajust();
		void resizeRequest() { emit(updateLayout()); }
	public slots:
		void showMenu();
		void notifyConfigChange();

		void showKbfxMenu();
		void showKmenu();
		void openKmenuEdit();
		void reloadConfig();
		void selfDeleter();
		void openConfigDialog();

	protected:
		void resizeEvent ( QResizeEvent * );
		void createRMenu();
		void createKbfx();

	private:

		KConfig *ksConfig;
		KbfxButton * kbfxBtn;
		KbfxSpinxMenuWidget * m_menuWidget;
		KbfxSpinxPopUp * m_menu;
		QWidget * m_parent;
		bool m_kicker_auto_adjust;

		//IPC
};

#endif
