/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <qlcdnumber.h>
#include <qbitmap.h>
#include <qlabel.h>
#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>
#include <krun.h>
#include <kapplication.h>
#include <kmessagebox.h>
#include <kbfxplasmaskinmanager.h>
#include <QtGui/QDesktopWidget>

#include "kbfxspinx.h"
#include "kbfxspinxview.h"
#include "kbfxplasmapixmapprovider.h"


KbfxSpinx::KbfxSpinx ( const QString& configFile, Plasma::Type type, int actions, QWidget *parent )
		: KPanelApplet ( configFile, type, actions, parent )
{
	m_parent = parent;
	m_menu = 0; // Set to NULL
	createKbfx();
//	if ( m_kicker_auto_adjust )
//		parent->resize ( parent->width(),kbfxBtn->height() );
}



void
KbfxSpinx::createKbfx()
{
	kbfxBtn = new KbfxButton ( this,"Kbfx Button" );
	kbfxBtn->installEventFilter ( this );
	if ( ConfigInit ().m_KbfxMenuType == "kmenu" )
	{
		kbfxBtn->show();
		kbfxBtn->repaint();
		reajust();
	}
	else
	{
		createRMenu();
		connect ( m_menu,SIGNAL ( aboutToHide () ),kbfxBtn,SLOT ( toggle() ) );
	}
	connect ( kbfxBtn  , SIGNAL ( pressed() ),this,SLOT ( showKbfxMenu() ) );
	if ( m_kicker_auto_adjust )
		m_parent->resize ( m_parent->width(),kbfxBtn->height() );
	resizeRequest();
}


void
KbfxSpinx::notifyConfigChange()
{
	kdDebug() << "Got DCOP Call notifyConfigChange"
	<< endl;
/*
	FIXME
	The delete here does not reload everything.
	Only the button and the parent menu.
	Carefull memory de-allocation is needed before deleteing further :-(
	Else be ready for a nice backtrace.
*/
	delete kbfxBtn;
	if ( m_menu != NULL )
	{
		delete m_menu;
	}
	KbfxPlasmaPixmapProvider::rebuildCache();
	ConfigInit().read();
	m_menu = 0; // Set to NULL
	createKbfx();
}

void
KbfxSpinx::createRMenu()
{
	m_menu = new KbfxSpinxPopUp ( this );
	m_menuWidget = new KbfxSpinxMenuWidget ( m_menu,"KbfxSpinxMenu" );
	m_menu->addItem ( m_menuWidget,0 );
	kbfxBtn->show();
	kbfxBtn->repaint();
	reajust();
	menuPosition();
}


void
KbfxSpinx::reajust()
{
	m_kicker_auto_adjust  = ConfigInit().m_ToolBarResize;
	if ( m_kicker_auto_adjust )
	{
		kdDebug () << "Readjust kicker to height: " << kbfxBtn->height () << endl;
		QByteArray data;
		QDataStream arg ( &data, IO_WriteOnly );
		arg << kbfxBtn->height ();
#warning PORT
#if 0
		if ( !m_dcopClient->send ( "kicker", "Panel", "setPanelSize(int)", data ) )
			kdWarning () << "Could not send DCOP command\n";
#endif
	}
}

void
KbfxSpinx::showKbfxMenu()
{
	if ( ConfigInit ().m_KbfxMenuType == "kmenu" )
	{
		showKmenu ();
	}
	else
	{
		m_menu->popup ( menuPosition() );
	}
}


void
KbfxSpinx::showKmenu()
{
	/* Import of old KBFX code */
	/**
		Note that there is no real way to know the
		height of the K-menu
	**/

	this->setCursor ( Qt::BlankCursor );

	QByteArray data, rdata;
	QDataStream arg ( &data, QIODevice::WriteOnly );
	QByteArray replytype;
	QPoint _tmp ( QCursor::pos () );

	if ( QCursor::pos ().y () > 128 )
	{
		QCursor::setPos ( this->mapToGlobal ( QPoint ( 0, 0 ) ) );
	}
	else
	{
		QCursor::setPos ( this->mapToGlobal ( this->geometry ().bottomLeft () ) );
	}

	arg << QPoint ( QCursor::pos () );

#warning PORT
#if 0
	if ( !m_dcopClient->
	        call ( "kicker", "kicker", "popupKMenu(QPoint)", data, replytype, rdata,
	               FALSE, -1 ) )
	{
		kdWarning () <<
		"**KBFX-APPLET-FATAL_ERROR:Could not send DCOP command\n";
	}
#endif

	this->setCursor ( Qt::ArrowCursor );
	QCursor::setPos ( _tmp );
	QTimer::singleShot (2000, kbfxBtn,SLOT ( toggle () ));
	kdDebug () << "Kmenu Called" << endl;
}

void
KbfxSpinx::showMenu()
{
	showKbfxMenu();
}

KbfxSpinx::~KbfxSpinx()
{}


void KbfxSpinx::about()
{
	KMessageBox::information ( 0, i18n ( "This is an about box" ) );
}


void KbfxSpinx::help()
{
	KMessageBox::information ( 0, i18n ( "This is a help box" ) );
}


void KbfxSpinx::preferences()
{
	KRun::runCommand ( "kbfxconfigapp", 0 );
}


void KbfxSpinx::openConfigDialog()
{
	KRun::runCommand ( "kbfxconfigapp", 0 );
}

void KbfxSpinx::openKmenuEdit()
{
#ifdef HAVE_MANDRAKE
	KRun::runCommand ( "menudrake", 0 );
#else
	KRun::runCommand ( "kmenuedit", 0 );
#endif
}

int KbfxSpinx::widthForHeight ( int height ) const
{
	height = height ; //TODO
	return kbfxBtn->width();
}

int KbfxSpinx::heightForWidth ( int width ) const
{
	width = width;
	return kbfxBtn->height();
}

void KbfxSpinx::resizeEvent ( QResizeEvent *e )
{
	KPanelApplet::resizeEvent ( e );
}

QPoint KbfxSpinx::menuPosition()
{
	QRect r = QDesktopWidget ().screenGeometry ( this );
	int popy = ( r.height () - ( m_menuWidget->height() + height () ) );
	QPoint xpoint = ( this->mapToGlobal ( QPoint ( 0, 0 ) ) );
	int popx = xpoint.x ();

	if ( position () != Plasma::Bottom )
	{
		return QPoint ( this->mapToGlobal ( this->geometry ().bottomLeft () ) );
	}

	return QPoint ( popx, popy );
}


void KbfxSpinx::selfDeleter()
{
#warning PORT
#if 0
	DCOPRef m_kickerPanel ( "kicker","Panel" );
	QStringList returnQStringList =m_kickerPanel.call ( "listApplets()" );
	int _myIndex = 0;

	QStringList::Iterator it;

	for ( it = returnQStringList.begin();it != returnQStringList.end();it++ )
	{
		if ( ( *it ).contains ( "kbfx" ) )
		{
			break;
		}
		else
			_myIndex++;
	}

	DCOPRef m_kickerPanelRef ( "kicker","Panel" );
	m_kickerPanelRef.call ( "removeApplet(int)", _myIndex );
#endif
}

void KbfxSpinx::reloadConfig()
{
#warning PORT
#if 0
	DCOPRef m_kickerkbfxDevelnterface ( "kicker","kbfxDevelnterface" );
	m_kickerkbfxDevelnterface.call ( "notifyConfigChange()" );
	m_kickerkbfxDevelnterface.call ( "notifyConfigChange()" );
	/*
		DCOPRef m_kickerPanel("kicker","Panel");
		m_kickerPanel.call("restart()");
	*/

#endif
}

bool
KbfxSpinx::eventFilter ( QObject *o, QEvent *e )
{
	o = o;
	if ( e->type() == QEvent::MouseButtonPress )
	{
		QMouseEvent *me = static_cast<QMouseEvent *> ( e );
		if ( me->button() == Qt::RightButton )
		{
			qDebug ( "Hey delete request" );

			QMenu *popup = new QMenu();

			popup->insertItem ( SmallIcon ( "remove" ), i18n ( "Remove KBFX from Pannel" ),
			                    this, SLOT ( selfDeleter() ) );
			popup->insertItem ( SmallIcon ( "reload" ),i18n ( "Reload KBFX" ),
			                    this, SLOT ( reloadConfig() ) );
			popup->insertSeparator();
			popup->insertItem ( SmallIcon ( "kbfxconfigapp" ), i18n ( "Configure KBFX" ),
			                    this, SLOT ( openConfigDialog() ) );
			popup->insertItem ( SmallIcon ( "kmenuedit" ),i18n ( "Edit Applications Menu" ),
			                    this, SLOT ( openKmenuEdit() ) );
			popup->exec ( me->globalPos() );
			delete popup;

			return true;
		}
		else
			return false;
	}


	return false;
}

extern "C"
{
	KPanelApplet* init ( QWidget *parent, const QString& configFile )
	{
		//KGlobal::locale()->insertCatalogue ( "KbfxSpinx" );
		return new KbfxSpinx ( configFile, Plasma::Normal,
		                       Plasma::About | Plasma::Help | Plasma::Preferences,
		                       parent );
	}
}

#include "kbfxspinx.moc"
