/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "kbfxplasmaskinmanager.h"
#include "qfileinfo.h"
#include  <kstandarddirs.h>

static KbfxPlasmaSkinManager::_themePixmapsNamesStruct _themePixmapsNamesObj[] =
    {
        { "appfind", "png" },
        { "bg", "png" },
        { "botbg", "png" },
        { "find", "png" },
        { "listboxbg", "png" },
        { "lock", "png" },
        { "lockhover", "png" },
        { "logout", "png" },
        { "logouthover", "png" },
        { "mask", "png" },
        { "menu_main_white_bg", "png" },
        { "menu_top", "png" },
        { "menu_top_image_person", "png" },
        { "rhshovertile", "png" },
        { "rhstile", "png" },
        { "separator", "png" },
        { "indexseparator", "png" },
        { "tabbg", "png" },
        { "tilehover", "png" },
        { "tilenormal", "png" },
        { "topbg", "png" },
        { "topbg2", "png" },
        { "scrollnormal", "png" },
        { "dudebox", "png" },
        { "fancymenuitem", "png" },
        { "sidebar_top","png"},
        { "bg_sidebar","png"}
    };

KbfxPlasmaSkinManager::KbfxPlasmaSkinManager()
{
//    ConfigInit ().read ();
	//ConfigInit().confskel->readConfig();
}

KbfxPlasmaSkinManager::~KbfxPlasmaSkinManager()
{}

QString  KbfxPlasmaSkinManager::getThemePixmapPath ( _themePixmaps _names )
{
//     ConfigInit().read();
	QString _path  = ConfigInit ().m_SpinxThemeBasePath + "/"+ConfigInit ().m_SpinxThemeName+"/";
	QString _pixmapfullname ( _themePixmapsNamesObj[_names].name + "." + _themePixmapsNamesObj[_names].extension );
	QFileInfo *  _info  = new QFileInfo ( _path + _pixmapfullname );

	if ( _info->exists() )
	{
		delete _info;
//	qDebug("Loading item ================================= "+ _path + _pixmapfullname);
		return QString ( _path + _pixmapfullname );
	}
	else
	{
		_path = KStandardDirs::locate ( "data", "kbfx/skins/default/" + _pixmapfullname );
		delete _info;
//	qDebug("Loading item ================================= "+ _path + _pixmapfullname);
		return _path;
	}



}


#include "kbfxplasmaskinmanager.moc"
