/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "kbfxplasmapixmapprovider.h"

int
KbfxPlasmaPixmapProvider::addPixmap ( QString pixmapname )
{


	QString lPath = ConfigInit ().m_SpinxThemeBasePath + "/"+ConfigInit ().m_SpinxThemeName+"/";
	QString lFileName = lPath + pixmapname + ".png";
	QPixmap * lPixmapPtr = 0;

	QFileInfo *  lInfo  = new QFileInfo ( lFileName );

	if ( !lInfo->exists() )
	{
		lFileName = KStandardDirs::locate ( "data", "kbfx/skins/default/" + pixmapname + ".png" );
	}

	delete lInfo;

	if ( ( lPixmapPtr = QPixmapCache::find ( pixmapname ) ) == NULL )
	{
		lPixmapPtr = new QPixmap ( lFileName );
		QPixmapCache::insert ( pixmapname,*lPixmapPtr );
		return ( lPixmapPtr->height() *lPixmapPtr->width() *lPixmapPtr->depth() ) /8;
	}
	return 0;
}

void
KbfxPlasmaPixmapProvider::deletePixmap ( const QString & key )
{
	QPixmapCache::remove ( key );
}

void
KbfxPlasmaPixmapProvider::rebuildCache()
{
	QPixmapCache::clear ();
	buildCache();
}

void KbfxPlasmaPixmapProvider::buildCache()
{
//m_skinElements.append("topbg");
	QPixmapCache::setCacheLimit ( 1024*5 );
	static QStringList  m_skinElements;
	m_skinElements
	<<"appfind"
	<<"bg"
	<<"botbg"
	<<"butterfly"
	<<"dudebox"
	<<"find"
	<<"hover"
	<<"indexseparator"
	<<"listboxbg"
	<<"lockhover"
	<<"lock"
	<<"logouthover"
	<<"logout"
	<<"mask"
	<<"menu_top_image_person"
	<<"menu_top"
	<<"normal"
	<<"off"
	<<"on"
	<<"pressed"
	<<"preview"
	<<"rhshovertile"
	<<"rhstile"
	<<"scrollnormal"
	<<"separator"
	<<"tabbg"
	<<"tilehover"
	<<"tilenormal"
	<<"middleboxbg"
	<<"topbg";

	for ( QStringList::Iterator it = m_skinElements.begin(); it != m_skinElements.end(); ++it )
	{
		QPixmapCache::setCacheLimit ( KbfxPlasmaPixmapProvider::addPixmap ( *it ) +QPixmapCache::cacheLimit() );
	}


}

QPixmap *
KbfxPlasmaPixmapProvider::pixmap ( const QString & key )
{
	QPixmap* pp;
	QPixmap p;
	if ( ( pp=QPixmapCache::find ( key ) ) )
	{
		return pp;
	}
	else
	{
		addPixmap ( key );
		return pixmap ( key );
	}

}

