/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "kbfxplasmacanvasitemwrapper.h"
//#include "kbfxplasmaskinmanager.h"
#include <kbfxplasmapixmapprovider.h>

#include <QtCore/QList>

KbfxPlasmaCanvasItemWrapper::KbfxPlasmaCanvasItemWrapper ( Q3Canvas * canvas )
{
	m_canvas = canvas;
}

KbfxPlasmaCanvasItemWrapper::~KbfxPlasmaCanvasItemWrapper ()
{}

Q3CanvasItem *
KbfxPlasmaCanvasItemWrapper::item ( KbfxPlasmaCanvasItem::Type __type )
{

	if ( __type == KbfxPlasmaCanvasItem::SEPARATOR )
	{
		QList<QPixmap> list;
		list.append ( ( *KbfxPlasmaPixmapProvider::pixmap ( "separator" ) ) );
		KbfxPlasmaCanvasItem *_ret =
		    new KbfxPlasmaCanvasItem ( new Q3CanvasPixmapArray ( list ),m_canvas );
		_ret->setType ( __type );
		return ( Q3CanvasItem * ) _ret;
	}

	if ( __type == KbfxPlasmaCanvasItem::EXECUTABLE )
	{

		QList<QPixmap> list;
		list.append ( ( *KbfxPlasmaPixmapProvider::pixmap ( "tilenormal" ) ) );
		list.append ( ( *KbfxPlasmaPixmapProvider::pixmap ( "tilehover" ) ) );

		Q3CanvasPixmapArray * _pArray = new Q3CanvasPixmapArray ( list );

		KbfxPlasmaCanvasItem *_ret = new KbfxPlasmaCanvasItem ( _pArray,
		                             m_canvas );

		_ret->setType ( __type );
		return ( Q3CanvasItem * ) _ret;
	}


	return 0;
}


Q3CanvasItem *
KbfxPlasmaCanvasItemWrapper::itemIndex ( KbfxPlasmaCanvasItem::Type __type )
{


	if ( __type == KbfxPlasmaCanvasItem::SEPARATOR )
	{
		QList<QPixmap> list;
		list.append ( ( *KbfxPlasmaPixmapProvider::pixmap ( "indexseparator" ) ) );
		KbfxPlasmaIndexItem *_ret =
		    new KbfxPlasmaIndexItem ( new Q3CanvasPixmapArray ( list ),m_canvas );
		_ret->setType ( __type );
		return ( Q3CanvasItem * ) _ret;
	}
	if ( __type  == KbfxPlasmaCanvasItem::INDEX )
	{
		QList<QPixmap> list2;
		list2.append ( ( *KbfxPlasmaPixmapProvider::pixmap ( "rhstile" ) ) );
		list2.append ( ( *KbfxPlasmaPixmapProvider::pixmap ( "rhshovertile" ) ) );
		KbfxPlasmaIndexItem *_ret = new KbfxPlasmaIndexItem ( new Q3CanvasPixmapArray ( list2 ),
		                            m_canvas );

		_ret->setType ( __type );
		return ( Q3CanvasItem * ) _ret;

	}
	return 0;
}

#include "kbfxplasmacanvasitemwrapper.moc"
