/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <config.h>

#include <kapplication.h>
#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kdebug.h>

#include "kbfxconfigapp.h"

static const char description[] = I18N_NOOP ( "KBFX Configuration Utility" );
static const char version[] = APPLICATION_VERSION;

int main ( int argc, char **argv )
{
	KAboutData about ( "kbfxconfigapp", 0,
	                   ki18n ( "kbfxconfigapp" ),
	                   version,
	                   ki18n(description),
	                   KAboutData::License_GPL,
	                   ki18n("(C) 2006 PhobosK"),
	                   KLocalizedString(),
	                   0,
	                   "phobosk@mail.kbfx.org" );

	about.addAuthor ( ki18n("PhobosK"), KLocalizedString(), "phobosk@mail.kbfx.org" );

	KCmdLineArgs::reset();
	KCmdLineArgs::init ( argc, argv, &about );

	KCmdLineOptions options;
	options.add("install <theme URL>", ki18n ( "Install KBFX theme from <URL>" ));
	options.add("prepare <folder URL>", ki18n ( "Prepare KBFX theme from folder <URL>" ));
	KCmdLineArgs::addCmdLineOptions ( options );
	KUniqueApplication::addCmdLineOptions();


//  KApplication app;
	KUniqueApplication app;
	KbfxConfigApp *mainWin = 0;

	mainWin = new KbfxConfigApp();
	app.setMainWidget ( mainWin );
//  mainWin->show();

	/* mainWin has WDestructiveClose flag by default, so it will delete itself */
	return app.exec();
}
