/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

void KbfxConfigDlgThemes::init()
{
	KbfxFormReady = FALSE;
	img_nopreview = image3;

	connect ( this, SIGNAL ( KbfxThemeDoInstall ( QString & ) ),
	          this, SLOT ( KbfxThemeInstall ( QString & ) ) );
}

/*
void KbfxConfigDlgThemes::KbfxDudeAnimationButtonToggled(bool)
{
  if(KbfxAnimationButton->state() == 2)
  {
    KbfxAnimationButton->setText(tr2i18n("Animation is ON"));
    KbfxAnimationButton->setPaletteBackgroundColor(QColor(0,255,0));
    ConfigInit().m_SpinxDudeBlink = TRUE;
  }

  if(KbfxAnimationButton->state() == 0)
  {
    KbfxAnimationButton->setText(tr2i18n("Animation is OFF"));
    KbfxAnimationButton->setPaletteBackgroundColor(QColor(221,223,228));
    ConfigInit().m_SpinxDudeBlink = FALSE;
  }

  kdDebug() << "SpinxDudeBlink State is:"
            << ConfigInit().m_SpinxDudeBlink
            << endl;
}
*/

void KbfxConfigDlgThemes::KbfxURLRequesterThemesPathUrlSelected ( const QString &path )
{
	QString tmppath = path;

	if ( tmppath.startsWith ( "file://" ) ) tmppath.remove ( "file://" );
	if ( !tmppath.endsWith ( "/" ) ) tmppath.append ( "/" );

	QDir d ( tmppath );
	d.setFilter ( QDir::Dirs );
	if ( !d.exists() )
	{
		kdDebug() << "Themes folder does not exist: " << tmppath << endl;

		KMessageBox::error ( 0,
		                     tr2i18n ( "Invalid user themes folder!"
		                               "\nWill use default user themes folder." ),
		                     tr2i18n ( "Error loading themes" ) );

		tmppath = ConfigInit().m_UserSpinxThemeBasePathDefault;
	}

	KbfxURLRequesterThemesPath->setURL ( tmppath );

	KbfxThemeList->clear();
	KbfxThemeList->insertStringList ( KbfxThemesData().setThemeList ( tmppath ).keys() );
	KbfxThemeList->setCurrentItem ( 0 );

	ConfigInit().m_SpinxThemeName = KbfxThemeList->currentText();
	ConfigInit().m_SpinxThemeBasePath = KbfxThemesData().setThemeList ( ConfigInit().m_UserSpinxThemeBasePath ) [ConfigInit().m_SpinxThemeName];
	ConfigInit().m_UserSpinxThemeBasePath = tmppath;

	setKbfxThemePreview();
}

void KbfxConfigDlgThemes::KbfxThemeSelected ( const QString &name )
{
	if (KbfxFormReady)
	{
		ConfigInit().m_SpinxThemeName = name;
		ConfigInit().m_SpinxThemeBasePath = KbfxThemesData().setThemeList ( ConfigInit().m_UserSpinxThemeBasePath ) [ConfigInit().m_SpinxThemeName];
		ConfigInit().readFontrc ( ConfigInit().m_SpinxThemeBasePath,
								  ConfigInit().m_SpinxThemeName );
		ConfigInit().readThemerc ( ConfigInit().m_SpinxThemeBasePath,
								   ConfigInit().m_SpinxThemeName );

		kdDebug() << "Selected theme: "
		<< name
		<< endl
		<< "Base path: "
		<< ConfigInit().m_SpinxThemeBasePath
		<< endl;

		setKbfxThemePreview();
	}
}

void KbfxConfigDlgThemes::setKbfxThemePreview()
{
	QString path = ConfigInit().m_SpinxThemeBasePath + ConfigInit().m_SpinxThemeName + "/preview.png";

	QImage tmp ( path );
	if ( tmp.isNull() )
	{
		kdDebug() << "No preview available for theme: "
		<< ConfigInit().m_SpinxThemeName
		<< endl;

		// QString default_path = locate("data", "kbfx/images/nopreview.png");
		KbfxPixmapPreview->setPixmap ( img_nopreview );
	}
	else
	{
		KbfxPixmapPreview->setPixmap ( path );
	}
}

void KbfxConfigDlgThemes::ChangeForm()
{
	KbfxFormReady = FALSE;
	KbfxURLRequesterThemesPath->setURL ( ConfigInit().m_UserSpinxThemeBasePath );
	KbfxThemeList->clear();

	KbfxThemeList->insertStringList ( KbfxThemesData().setThemeList ( ConfigInit().m_UserSpinxThemeBasePath ).keys() );

	kdDebug() << "Theme path: "
	<< KbfxThemesData().setThemeList ( ConfigInit().m_UserSpinxThemeBasePath ) [ConfigInit().m_SpinxThemeName]
	<< endl;

	KbfxThemeList->setSelected ( KbfxThemeList->findItem ( ConfigInit().m_SpinxThemeName ), TRUE );

	setKbfxThemePreview();

	KbfxDudeImage->setPixmap ( ConfigInit().m_SpinxDudeImage );

	kdDebug() << "Dude image: "
	<< ConfigInit().m_SpinxDudeImage
	<< endl
	<< "Default dude image: "
	<< ConfigInit().m_SpinxDudeImageDefault
	<< endl;

	KbfxFormReady = TRUE;

	/*
	  if(ConfigInit().m_SpinxDudeBlink == TRUE && KbfxAnimationButton->state() == 0)
	    KbfxAnimationButton->toggle();

	  if(ConfigInit().m_SpinxDudeBlink == FALSE && KbfxAnimationButton->state() == 2)
	    KbfxAnimationButton->toggle();
	*/
}

void KbfxConfigDlgThemes::KbfxDeleteThemeClicked()
{
	int messageBoxReturn;
	messageBoxReturn = KMessageBox::warningContinueCancel ( 0,
	                   tr2i18n ( "<p>Are you sure you want to uninstall the KBFX "
	                             "theme <strong>%1</strong>?</p>" ).arg ( ConfigInit().m_SpinxThemeName ),
	                   tr2i18n ( "Uninstall KBFX theme" ),
	                   tr2i18n ( "Uninstall" ) );

	if ( messageBoxReturn == KMessageBox::Cancel ) return;

	kdDebug() << "Deleting theme: "
	<< ConfigInit().m_SpinxThemeName
	<< " - "
	<< ConfigInit().m_SpinxThemeBasePath + ConfigInit().m_SpinxThemeName
	<< endl;

	if ( !KIO::NetAccess::del ( ConfigInit().m_SpinxThemeBasePath+ConfigInit().m_SpinxThemeName, 0 ) )
	{
		KMessageBox::sorry ( 0,
		                     tr2i18n ( "<p>Could not uninstall this KBFX theme.</p>"
		                               "<p>You may not have sufficient permissions to delete "
		                               "the folder <strong>%1<strong></p>." ).arg ( ConfigInit().m_SpinxThemeBasePath + ConfigInit().m_SpinxThemeName ) );

		return;
	}

	ChangeForm();
}

void KbfxConfigDlgThemes::KbfxInstallThemeClicked()
{
	KFileDialog KbfxInstallDialog ( QString::null,
	                                "*.tar *.tar.bz2 *.tar.gz *.kbfxtheme|" + tr2i18n ( "KBFX theme packages (*.tar, *.tar.bz2, *.tar.gz, *.kbfxtheme)" ),
	                                0,
	                                0,
	                                TRUE );
	KbfxInstallDialog.setCaption ( tr2i18n ( "Select KBFX theme package to install" ) );
	KbfxInstallDialog.setMode ( KFile::File | KFile::ExistingOnly );

	if ( !KbfxInstallDialog.exec() ) return;

	KbfxInstallDialogURL = KbfxInstallDialog.selectedURL().path();

	emit KbfxThemeDoInstall ( KbfxInstallDialogURL );
}

void KbfxConfigDlgThemes::KbfxThemeInstall ( QString &installUrl )
{
	KTar KbfxThemeArchive ( installUrl );

	if ( !KbfxThemeArchive.open ( IO_ReadOnly ) )
	{
		KMessageBox::sorry ( 0, tr2i18n ( "Could not read this KBFX theme package." ) );

		kdDebug() << "Error reading archive: " << installUrl << endl;

		return;
	}

	const QString KbfxThemeDestination = KGlobal::dirs()->saveLocation ( "data",
	                                     QString ( "kbfx/skins/" ),
	                                     TRUE );

	kdDebug() << "Copying theme: " << KbfxThemeDestination << endl;

	const KArchiveDirectory *KbfxThemeArchiveDir = KbfxThemeArchive.directory();
	KbfxThemeArchiveDir->copyTo ( KbfxThemeDestination, TRUE );

	ChangeForm();
}

void KbfxConfigDlgThemes::KbfxSelectDudeImageClicked()
{
	KFileDialog KbfxDudeImageDialog ( QString::null,
	                                  "image/jpeg image/png image/x-xpm image/gif ",
	                                  0,
	                                  0,
	                                  TRUE );

	KbfxDudeImageDialog.setCaption ( tr2i18n ( "Select personal image" ) );
	KbfxDudeImageDialog.setMode ( KFile::File | KFile::ExistingOnly );

	if ( !KbfxDudeImageDialog.exec() ) return;

	ConfigInit().m_SpinxDudeImage = KbfxDudeImageDialog.selectedURL().path();

	QImage tmp ( ConfigInit().m_SpinxDudeImage );
	if ( tmp.isNull() )
	{
		KMessageBox::error ( 0,
		                     tr2i18n ( "Image cannot be used as a personal image!"
		                               "\nWill use default personal image." ),
		                     tr2i18n ( "Error loading image" ) );

		ConfigInit().m_SpinxDudeImage=ConfigInit().m_SpinxDudeImageDefault;
	}

	KbfxDudeImage->setPixmap ( ConfigInit().m_SpinxDudeImage );

	kdDebug() << "Dude image changed: "
	<< ConfigInit().m_SpinxDudeImage
	<< endl;
}


void KbfxConfigDlgThemes::KbfxDeleteDudeImageClicked()
{
	QString tmp_dude = ConfigInit().m_SpinxThemeBasePath + ConfigInit().m_SpinxThemeName + "/menu_top_image_person.png";
	QFile tmp ( tmp_dude );
	if ( tmp.exists() )
	{
		ConfigInit().m_SpinxDudeImage = tmp_dude;
	}
	else
	{
		ConfigInit().m_SpinxDudeImage = locate ( "data","kbfx/skins/default/menu_top_image_person.png" );
	}

	KbfxDudeImage->setPixmap ( ConfigInit().m_SpinxDudeImage );
}
