/*
 *     Copyright (C) 2007 the ktimetracker developers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the
 *      Free Software Foundation, Inc.
 *      51 Franklin Street, Fifth Floor
 *      Boston, MA  02110-1301  USA.
 *
 */

#include "ktimetrackerengine.h"

#include <QDBusConnection>
#include <QDBusInterface>
#include <QDBusReply>
#include <QTimer>

KTimetrackerEngine::KTimetrackerEngine( QObject* parent, const QVariantList& args )
{
  Q_UNUSED( args );
  m_timer = new QTimer( this );
  m_timer->setSingleShot( false );
  connect( m_timer, SIGNAL( timeout() ),
           this, SLOT( updateData() ) );
}

bool KTimetrackerEngine::sourceRequested( const QString &name )
{
  if ( name != "timetracker" ) {
    return false;
  } else {
    updateData();

    if ( !m_timer->isActive() ) {
      m_timer->start();
    }

    return true;
  }
}

void KTimetrackerEngine::updateData()
{
  QDBusInterface iface( "org.kde.karm", "/Karm", "org.kde.karm.Karm", QDBusConnection::sessionBus() );
  QDBusReply<QStringList> reply;
  bool valid = iface.isValid();
  if ( valid ) {
    if ( ( reply = iface.call( "getActiveTasks" ) ).isValid() ) {
      setData( "timetracker", "activetasks", reply.value() );
    }

    if ( ( reply = iface.call( "getTasks" ) ).isValid() ) {
      setData( "timetracker", "tasks", reply.value() );
    }
  }
  setData( "timetracker", "ktimetracker-running", valid );

  checkForUpdates();
}

#include "ktimetrackerengine.moc"
