#include "wellcomeitem.h"
#include <QPainter>
#include <KIcon>
#include <kicontheme.h>
#include <QPainterPath>
#include <QtGui>
#include <QtCore>
#include "wellcomeitem.moc"

class
  WellcomeItem::Private
{
public:
  Private ()
  {
  }
  ~
  Private ()
  {
  }
  int
    height;
  int
    width;
  Plasma::Svg * m_theme;
  QString
    text;
  QString
    comment;
  QString
    tooltip;
  QString
    icon;
  int
    Rating;
  MouseState
    state;
  ThemeNames
    ids;
  QSize
    size;
  QSize
    elementSize;
  QPixmap
    iconPixmap;
  float
    opacity;
  //Grid
  int
    ncol;
  int
    nrow;
  QTimeLine
    timeline;
  QImage
    refimg;
  bool
    blured;
};


WellcomeItem::WellcomeItem (QGraphicsItem * parent):Plasma::Widget (parent),
d (new Private)
{
//TODO
  setAcceptsHoverEvents (true);
  d->height = 330;
  d->width = 340;
  d->m_theme = new Plasma::Svg ("menu/raptorslide", this);
  d->m_theme->resize (d->width, d->height);
//TODO get rid of thsese stuff 
  d->size = d->m_theme->size ();
  d->elementSize = d->m_theme->elementSize ("itemNormal");
  d->iconPixmap = QPixmap ();
  d->opacity = 1.0f;
//FIXME: need methods for these
  d->nrow = 4;
  d->ncol = 4;
//simple animation
  d->timeline.setDuration (200);
  d->timeline.setFrameRange (0, 120);
  d->timeline.setCurveShape(QTimeLine::EaseInCurve);
//  d->timeline.setUpdateInterval(1000/100);
  connect (&d->timeline, SIGNAL (frameChanged (int)), this,
	   SLOT (zoom (int)));
  d->blured = false;
  d->refimg = QImage (d->elementSize, QImage::Format_ARGB32_Premultiplied);
  d->refimg = reflection (d->refimg);

}

WellcomeItem::~WellcomeItem ()
{
  delete d->m_theme;
  delete d;
}

QImage
WellcomeItem::reflection (QImage & img)
{
  QImage reflect = img.mirrored (0, 1);
  QPainter p (&reflect);
  QPoint x, y;

  y.setY (reflect.height ());
  QLinearGradient grad (x, y);
  grad.setColorAt (0, QColor (0, 0, 0, 50));
  grad.setColorAt (1, Qt::transparent);
  p.setCompositionMode (QPainter::CompositionMode_DestinationIn);

  p.fillRect (QRect (0, 0, reflect.width (), reflect.height ()), grad);
  p.end ();
  return reflect;
}

void
WellcomeItem::paintItem (QPainter * painter,
			const QRectF rect)
{
  painter->setRenderHint (QPainter::SmoothPixmapTransform,false);
  painter->setRenderHint (QPainter::SmoothPixmapTransform,true);

  d->m_theme->resize (d->width, d->height);
  QRectF source (0, 0, d->elementSize.width (), d->elementSize.height ());
//  d->m_theme->paint (painter, 0, 0, "itemNormal");
  if (!d->iconPixmap.isNull ())
    {
      painter->
	drawPixmap (int
		    (((int) source.width () - d->iconPixmap.width ()) / 2),
		    int (((int) source.height () -
			  d->iconPixmap.height ()) / 2),
		    d->iconPixmap.height (), d->iconPixmap.width (),
		    d->iconPixmap);
    }
/*
  painter->setRenderHint (QPainter::Antialiasing, true);
  QRectF textRect (2,
		   (-6) + d->iconPixmap.height () + ((int) source.height () -
						     d->iconPixmap.
						     height ()) / 2,
		   d->elementSize.width () - 4,
		   painter->fontMetrics ().height ());
*/


}
void
WellcomeItem::paint (QPainter * painter,
		     const QStyleOptionGraphicsItem * option,
		     QWidget * widget)
{
  Q_UNUSED (widget);
    this->paintItem (painter, option->exposedRect);
    painter->drawImage(QPoint(0,0),d->refimg);
}

void
WellcomeItem::setOpacity (float op)
{
  d->opacity = op;
}

QString
WellcomeItem::loadSvg (MouseState state)
{
  return d->ids[state];
}

QSizeF
WellcomeItem::sizeHint ()  const
{
  return QSizeF (d->width, d->width * 2);
}

QSizeF
WellcomeItem::minimumSize ()  const
{
  return QSizeF (d->width, d->height * 2);
}

QRectF
WellcomeItem::geometry ()  const
{
  return QRectF (0, 0, d->width, d->height * 2);
}

QSizeF
WellcomeItem::maximumSize ()  const
{
  return QSizeF (d->width, d->height * 2);
}

QRectF
WellcomeItem::boundingRect () const
{
  return QRectF (0, 0, d->elementSize.width (), d->elementSize.height () * 2);
}

//Events

void
WellcomeItem::hoverEnterEvent (QGraphicsSceneHoverEvent * event)
{
  Q_UNUSED (event);
  d->state = OVER;
  update ();
  d->timeline.setDirection (QTimeLine::Forward);
  if (d->timeline.state () == QTimeLine::NotRunning)
    d->timeline.start ();
  emit clicked ();
}

void
WellcomeItem::hoverMoveEvent (QGraphicsSceneHoverEvent * event)
{
  Q_UNUSED (event);
  d->state = OVER;
  update ();

}

void
WellcomeItem::hoverLeaveEvent (QGraphicsSceneHoverEvent * event)
{
  Q_UNUSED (event);
  d->state = REGULAR;
  update ();
  d->timeline.setDirection (QTimeLine::Backward);
  if (d->timeline.state () == QTimeLine::NotRunning)
    d->timeline.start ();

}

QString
WellcomeItem::name ()
{
  return d->text;
}

void
WellcomeItem::setName (const QString & name)
{
  d->text = name;
}

void
WellcomeItem::setIcon (QPixmap icon)
{
  d->iconPixmap = QPixmap (icon);
  //FIXME
  //Optimize
  QImage Buffer = icon.toImage();
  d->refimg = d->refimg.scaled(boundingRect().width(),boundingRect().height()*2);
  QPainter p (&d->refimg);
  
  p.setRenderHint(QPainter::Antialiasing);
  p.setRenderHint(QPainter::SmoothPixmapTransform);
  p.setCompositionMode (QPainter::CompositionMode_Source);
  p.fillRect (QRect(0,0,boundingRect().width(),boundingRect().height()*2), Qt::transparent);

  Buffer = reflection(Buffer);
  Buffer = Blitz::blur (Buffer, 2);
  QTransform trans;
  trans.translate(30,100);
  p.setTransform(trans);
  p.drawImage (QPoint (0,0),Buffer);
  p.end();

}

void
WellcomeItem::zoom (int step)
{

  QPointF center = this->boundingRect ().center ();
  resetMatrix ();
  QTransform mat = this->transform ();
  mat.translate (center.x (), center.y ());
  mat.scale (1 + step / 350.0, 1 + step / 350.00);
  mat.translate (-(center.x ()), -center.y ());

  this->setTransform (mat);

}
