//LGPL siraj razick siraj@kde.org
#include "welcomeapplet.h"
#include "wellcomeitem.h"
#include <QPainter>

#include <plasma/svg.h>
#include <plasma/widgets/vboxlayout.h>
#include <plasma/widgets/lineedit.h>
#include <KIcon>


WelcomeApplet::WelcomeApplet(QObject *parent, const QVariantList &args)
    : Plasma::Applet(parent, args)
{
    setDrawStandardBackground(false);
    int toppadding = 40;
    int padding = 10;
    icon1 = new WellcomeItem(this);
    icon1->setName("");
    icon1->setIcon(KIcon ("rating").pixmap(96,96));
    icon1->setPos(0,toppadding);
    
    icon2 = new WellcomeItem(this);
    icon2->setName("");
    icon2->setIcon(KIcon ("user").pixmap(96,96));
    icon2->setPos((icon1->boundingRect().width())+padding,toppadding);
 
    icon3 = new WellcomeItem(this);
    icon3->setName("");
    icon3->setIcon(KIcon ("book2").pixmap(96,96));
    icon3->setPos(icon2->boundingRect().width()*2,toppadding);
    
    icon4 = new WellcomeItem(this);
    icon4->setName("");
    icon4->setIcon(KIcon ("system-help").pixmap(96,96));
    icon4->setPos(icon3->boundingRect().width()*3,toppadding);

}
QRectF WelcomeApplet::boundingRect() const
{
    return QRectF(0, 0,icon1->boundingRect().width()*5,icon1->boundingRect().height()+100);
}


WelcomeApplet::~WelcomeApplet()
{
}

void WelcomeApplet::editUpdate(const QString&)
{
    prepareGeometryChange();
}

QSizeF WelcomeApplet::contentSizeHint() const
{
    return QSizeF(300, 300);
}


void WelcomeApplet::paintInterface(QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect &contentsRect)
{

    Q_UNUSED(option)
            QRectF  textRect(0,0,300,200); 
  
            painter->setPen(QColor(255,255,255));
            QFont qf("Arial",25);
            qf.setStyle(QFont::StyleOblique);
            painter->setFont(qf);
            painter->drawText(textRect,Qt::AlignLeft,"Welcome");

            painter->drawPixmap(QPoint(160,15),KIcon ("start-here").pixmap(32,32));

}

#include "welcomeapplet.moc"
