/***************************************************************************
 *   Copyright (C) 2007 by Alexis Ménard <darktears31@gmail.com>           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef SOLIDNOTIFIER_H
#define SOLIDNOTIFIER_H

#include <plasma/applet.h>
#include <plasma/dataengine.h>
#include <plasma/phase.h>
#include <KIcon>
#include <QTimer>

namespace Plasma
{
    class LineEdit;
    class Svg;
    class Widget;
    class VBoxLayout;
    class Label;
} // namespace Plasma


class SolidNotifier : public Plasma::Applet
{
    Q_OBJECT
    public:
        SolidNotifier(QObject *parent, const QVariantList &args);
        ~SolidNotifier();

        QSizeF contentSizeHint() const;
        void paintInterface(QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect &contentsRect);
        void moveUp();

    public slots:
        void SourceAdded(const QString &name);
        void updated(const QString &source, Plasma::DataEngine::Data data);
        void moveDown();
        void hideNotifier(QGraphicsItem * item);

    private:
        Plasma::Widget* m_edit;
        Plasma::Svg* m_svg;
        Plasma::Svg* m_theme;
        Plasma::Label * m_label;
        bool icon;
        QTimer *t;
        Plasma::DataEngine* SolidEngine;
        QStringList desktop_files;
        QString m_udi;
        QString device_name;
        KIcon * k_icon;
        int m_pixelSize;
};

K_EXPORT_PLASMA_APPLET(solidnotifier, SolidNotifier)

#endif
