/***************************************************************************
 *   Copyright (C) 2007 by Alexis Ménard <darktears31@gmail.com>           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#include "solidnotifier.h"

#include <QPainter>

#include <plasma/svg.h>
#include <plasma/widgets/hboxlayout.h>
#include <plasma/widgets/label.h>
#include <plasma/widgets/widget.h>
#include <plasma/widgets/icon.h>


#include <QtDBus/QDBusInterface>
#include <QtDBus/QDBusReply>

using namespace Plasma;

class IconNotifier : public Plasma::Icon
{
    public:
        explicit IconNotifier(const QString &text, QGraphicsItem *parent = 0)
    : Plasma::Icon(text, parent)
                {
                }
                IconNotifier(const KIcon & icon, const QString &text, QGraphicsItem *parent = 0): Plasma::Icon(icon,text, parent)
                {
                }
                void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0)
                {
                    paint(painter,option,widget);
                }
    private:
        KIcon m_icon;
};


SolidNotifier::SolidNotifier(QObject *parent, const QVariantList &args)
    : Plasma::Applet(parent, args)
        , m_edit( new Widget(this) )
        , m_svg( 0 )
{
    setDrawStandardBackground(true);
    //KConfigGroup cg = config();
    //m_pixelSize = cg.readEntry("size", 200);
    m_edit->setGeometry(QRect(0,0,200,70));
    SolidEngine = dataEngine("solidnotifierengine");
    t=new QTimer(this);
    m_udi="";
    icon = false;
    m_label=new Label(this);
    //connect the timer to MoveDown Animation
    connect(t,SIGNAL(timeout()),this,SLOT(moveDown()));

    //connect to engine when a device is plug
    connect(SolidEngine, SIGNAL(newSource(const QString&)),this, SLOT(SourceAdded(const QString&)));
    hide();
}

SolidNotifier::~SolidNotifier()
{
}

QSizeF SolidNotifier::contentSizeHint() const
{
    //return QSizeF(300, 300);
    return m_edit->sizeHint();
    //return m_svg->size();
}


void SolidNotifier::paintInterface(QPainter *p, const QStyleOptionGraphicsItem *option, const QRect &contentsRect)
{
    Q_UNUSED(option);
    //icon=true;
    if(icon)
    {
        //k_icon=new KIcon("drive-removable-media-usb");
        k_icon->paint(p,0,10,50,50);
        m_label->setPen(QPen(Qt::white));
        m_label->setText(device_name);
        //how geometry work?value are strange...
        m_label->setGeometry(QRect(20,15,300,100));
        m_label->paintWidget(p,option,(QWidget*)this);
        m_label->setPen(QPen(Qt::black));
        //FIXME I don't know why it doesn't work
        /*IconNotifier* m_icon= new IconNotifier(KIcon("drive-removable-media-usb"),"drive-removable-media-usb",this);
        m_icon->setGeometry(QRect(0,20,30,30));
        m_icon->paint(p,option,(QWidget*)this);*/
    }
    p->drawText(0,-10,"Solid Notifier");
}

void SolidNotifier::hideNotifier(QGraphicsItem * item)
{
    item->hide();
}

void SolidNotifier::moveUp()
{
    t->start(5000);
    disconnect(Phase::self(),SIGNAL(movementComplete(QGraphicsItem *)),this,SLOT(hideNotifier(QGraphicsItem *)));
    show();
    Phase::self()->moveItem(this, Phase::SlideIn,QPoint(0,20));
}


void SolidNotifier::moveDown()
{
    t->stop();
    Phase::self()->moveItem(this, Phase::SlideOut,QPoint(0,20));
    connect(Phase::self(),SIGNAL(movementComplete(QGraphicsItem *)),this,SLOT(hideNotifier(QGraphicsItem *)));
    //QDBusInterface soliduiserver("org.kde.kded", "/modules/soliduiserver", "org.kde.kded.SolidUiServer");
    //QDBusReply<void> reply = soliduiserver.call("showActionsDialog", m_udi,desktop_files);
}


void SolidNotifier::updated(const QString &source, Plasma::DataEngine::Data data)
{
    kDebug()<<"SolidNotifier:: "<<data[source].toString();
    desktop_files=data["desktoplist"].toStringList();
    kDebug()<<data["icon"].toString();
    QString icon_temp = data["icon"].toString();
    k_icon = new KIcon(icon_temp);
    icon = true;
    device_name=data["text"].toString();
    update();
    moveUp();
}

void SolidNotifier::SourceAdded(const QString& source)
{
    //kDebug()<<data_source.size();
    m_udi = source;
    SolidEngine->connectSource(source, this);
}


#include "solidnotifier.moc"
