/*
 *   Copyright (C) 2007 Zack Rusin <zack@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef SAMPLEITEM2_H
#define SAMPLEITEM2_H

#include <plasma/dataengine.h>
#include <plasma/glapplet.h>

#include <QtGui/QWidget>
#include <QtCore/QObject>
#include <QtCore/QTimeLine>
#include <QtSvg/QSvgRenderer>
#include <QGLFramebufferObject>

class QHttp;

class SampleItem2 : public Plasma::GLApplet
{
    Q_OBJECT
public:
    SampleItem2(QObject *parent, const QVariantList &args);
    ~SampleItem2();

    virtual QRectF boundingRect() const;
    qreal width() const {
        return boundingRect().width();
    }
    qreal height() const {
        return boundingRect().height();
    }
    virtual void paintGLInterface(QPainter *painter,
                                  const QStyleOptionGraphicsItem *option);

    void saveGLState();
    void restoreGLState();

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *);
    void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *);
    void mouseMoveEvent(QGraphicsSceneMouseEvent *);
    void hoverMoveEvent(QGraphicsSceneHoverEvent *e);
    void timerEvent(QTimerEvent *);
    void wheelEvent(QGraphicsSceneWheelEvent *);

public slots:
    void animate(qreal);
    void animFinished();
    void draw(QPainter &p);

private:
    QPoint anchor;
    float scale;
    float rot_x, rot_y, rot_z;
    GLuint tile_list;
    GLfloat *wave;

    QImage logo;
    QTimeLine *anim;
    QSvgRenderer *svg_renderer;
    QGLFramebufferObject *fbo;
};

K_EXPORT_PLASMA_APPLET(testgl2, SampleItem2)

#endif
