/*
 *   Copyright (C) 2007 Zack Rusin <zack@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef ROTATOR_H
#define ROTATOR_H

#include <plasma/applet.h>
#include <plasma/dataengine.h>

#include <QtGui/QWidget>
#include <QtGui/QPixmap>
#include <QtGui/QTransform>
#include <QtCore/QTimer>
#include <QtCore/QObject>

class Rotator : public Plasma::Applet
{
    Q_OBJECT
public:
    Rotator(QObject *parent, const QVariantList &args);
    ~Rotator();

    virtual QRectF boundingRect() const;
    virtual void paintInterface(QPainter *painter,
                                const QStyleOptionGraphicsItem *option,
                                const QRect & contentsRect);
protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *);
    void mouseMoveEvent(QGraphicsSceneMouseEvent *);
    void wheelEvent(QGraphicsSceneWheelEvent *);

protected slots:
    void rotate();

private:
    QTransform m_transform;
    int        m_degrees;
    QTimer     m_timer;
    QPixmap    m_pixmap;
};

K_EXPORT_PLASMA_APPLET(rotator, Rotator)

#endif
