/*
    Header of the kdebug applet for Plasma.
    Copyright (C) 2007 Tim Beaulen <tbscope@gmail.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef KDEBUGAPPLET_H
#define KDEBUGAPPLET_H

#include <Plasma/Applet>
#include <Plasma/Svg>
#include <QtDBus/QtDBus>
#include <QTimer>
#include <QString>
#include <QStringList>

#include "kdebug_interface.h"

class KDebugApplet : public Plasma::Applet
{
    Q_OBJECT

public:
    KDebugApplet(QObject *parent, const QVariantList &args);
    ~KDebugApplet();

    QSizeF contentSizeHint() const;
    void constraintsUpdated();

    void paintInterface(QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect &contentsRect);

private slots:
    void timerUpdate();
    void newMessage(const QString& message);

private:
    //Plasma::Svg m_svg;
    QSizeF m_sizeHint;
    KDebugInterface *m_kdebugInterface;
    QTimer *m_timer;
    QString m_connectTxt;
    QStringList m_messages;
};

K_EXPORT_PLASMA_APPLET(kdebug, KDebugApplet)

#endif

