#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

BEGIN {
    plan skip_all
        => "GitHub tests require DPT_GITHUB_OAUTH token and Net::GitHub"
        unless $ENV{DPT_GITHUB_OAUTH}
        and $ENV{DPT_GITHUB_OAUTH} =~ /^\w+$/
        and eval "use Net::GitHub; 1";
}

my $gh = new_ok('Net::GitHub::V3', [
    access_token => $ENV{DPT_GITHUB_OAUTH},
]);

my $login = 'debian-perl';
is( $gh->user->show($login)->{login}, $login, $login );

done_testing();
