#ifndef __KIF_SLIDESHOW_H
#define __KIF_SLIDESHOW_H

#include <qwidget.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qtimer.h>

#include <qvariant.h>
#include <X11/X.h>
#include <X11/Xlib.h>

class KIFSlideShow : public QWidget
{
    Q_OBJECT
public:
    KIFSlideShow(const QStringList &fileList, int delay,
                 bool maxpect, bool loop, int effectType,
                 int effectDelay, QWidget *parent=0,
                 const char *name=0);
    ~KIFSlideShow();
protected slots:
    void slotTimer();
protected:
    void paint(const QRect &);
    void paintEvent(QPaintEvent *ev);
    void closeEvent(QCloseEvent *ev);
    void mousePressEvent(QMouseEvent *ev);
    void scaleImage(QImage &img);
    QPixmap *pix, *nextPix;
    QPixmap *effectFrame[4];
    QImage *img, *nextImg;
    bool max, looping;
    int time, effectTime, effect;
    QStringList list;
    QStringList::Iterator it;
    QTimer t;
    QColor c;
    GC gc;
};


#endif


