#ifndef __KIF_SCROLLTOPLEVEL_H
#define __KIF_SCROLLTOPLEVEL_H

#include <qscrollview.h>
#include "imagebuffer.h"

class KIFScrollTopLevel : public QScrollView
{
    Q_OBJECT
public:
    KIFScrollTopLevel(KIFImage *image, QWidget *parent=0,
    	const char *name=0);
public slots:
    void slotUpdateFromImage();
    void slotInvalidFile();
protected slots:
    void slotHideAll();
    void slotShowAll();
signals:
    void prevList();
    void nextList();
    void nextImage();
    void prevImage();
    void finished();
protected:
    void drawContents(QPainter *p, int x, int y, int w, int h);
    void closeEvent(QCloseEvent *ev);
    void keyPressEvent(QKeyEvent *ev);

    QPixmap pix;
    KIFImage *imageBuffer;
    bool visible;
};


#endif


