#ifndef __KIF_IMAGECOMPARE_H
#define __KIF_IMAGECOMPARE_H

#include <qasciidict.h>
#include <qsemimodal.h>
#include <qdatetime.h>
#include <qtooltip.h>
#include <qfile.h>
#include <qlistview.h>
#include <qpixmap.h>

class QFileInfo;
class QImage;
class QLabel;
class KProgress;
class UIManager;
class KDirWatch;

typedef struct __kif_comparedata
{
    unsigned char data[32];
    QDateTime time;
}KIFCompareData;

class CompareTip : public QToolTip
{
public:
    CompareTip(QWidget *parent, QToolTipGroup *group) : QToolTip(parent, group){;}
    void maybeTip(const QPoint &p);
};

class KIFCompareView : public QListView
{
    Q_OBJECT
public:
    KIFCompareView(const QString &path, int iconSize, const char *name=0);
    ~KIFCompareView();
    QPixmap& tempFill(){return(tmpPix);}
    QColorGroup parentColorGroup(){return(parentCg);}
    void makeThumbnails();
signals:
    void imageSelected(const QString &path);
    void addToFileList(const QString &path);
protected slots:
    void slotDoubleClicked(QListViewItem *item);
    void slotDirChanged(const QString &path);
    void slotRightButton(QListViewItem *item, const QPoint &p, int);
protected:
    void closeEvent(QCloseEvent *ev);

    CompareTip *tips;
    QColorGroup parentCg;
    KDirWatch *dirWatch;
    QPixmap tmpPix, emptyPix;
    bool stopProcessing;
};

class KIFCompareViewItem : public QListViewItem
{
public:
    KIFCompareViewItem(KIFCompareView *parent, const QString &path, int iconSize);
    KIFCompareViewItem(KIFCompareViewItem *parent, const QString &path,
                       int bitcount, int iconSize);
    void paintCell(QPainter *p, const QColorGroup &cg, int col, int w,
                   int align);
    void paintBranches(QPainter *p, const QColorGroup &cg, int w, int y,
                       int h);
    QString calcSizeString(int size);
    void calcPixmap();
    QString key(int col, bool ascending) const;
    void setup();
    void setOpen(bool open);
    QString path(){return(pathStr);}
    void setPath(const QString &str){pathStr = str;}
protected:
    QString pathStr;
    int bits;
    int iSize;
};



class KIFCompare : public QSemiModal
{
    Q_OBJECT
public:
    KIFCompare(const QString &path, int iconSize, UIManager *manager,
               QWidget *parent=0, const char *name=0);
    void generateCompareData();
    KIFCompareView *compareView(){return(view);}
protected slots:
    void slotStopClicked();
signals:
    void updateProgress(int val);
    void setStatusBarText(const QString &text);
protected:
    void closeEvent(QCloseEvent *ev);
    void loadCompareData(QFileInfo *fi);
    void loadCompareDB();
    void writeCompareDB();
    void runCompare();
    int countBits(unsigned char val);
    void outputFingerPrint(const unsigned char *data);
    bool checkIfMatched(const QString &first, const QString &second);

    QAsciiDict<KIFCompareData>fileList;
    QString dirPath;
    bool stopProcessing;
    bool modified;
    QFile dbFile;
    QLabel *stepLbl;
    KProgress *progress;
    int iSize;
    QTime testTime;
    UIManager *mgr;
    KIFCompareView *view;
};





#endif

