#ifndef __KIF_FILEOP_H
#define __KIF_FILEOP_H

#include <qdialog.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <kbuttonbox.h>

enum OpType{Rename=0, AutoRename, Skip, SkipAll, Overwrite, OverwriteAll, None};

class KIFFileOpDialog : public QDialog
{
    Q_OBJECT
public:
    KIFFileOpDialog(const QString &src, const QString &dest,
                    QWidget *parent=0, const char *name=0, bool singleFile = false);
    OpType fileOpSelection(){return(op);}
    QString renameString(){return(renameEdit->text());}
protected slots:
    void slotRename(){op=Rename; accept();}
    void slotAutoRename(){op=AutoRename; accept();}
    void slotSkip(){op=Skip; accept();}
    void slotSkipAll(){op=SkipAll; accept();}
    void slotOverwrite(){op=Overwrite; accept();}
    void slotOverwriteAll(){op=OverwriteAll; accept();}

    void slotRenameEnabled(const QString &){renameBtn->setEnabled(true); renameBtn->setDefault(true);}
protected:
    OpType op;
    QLineEdit *renameEdit;
    QPushButton *renameBtn;
};

class KIFFileTransfer : public QObject
{
public:
    static bool transferFiles(QStringList &fileList, const QString &dest,
                              QDropEvent::Action action);
    static bool transferFile(const QString &src, const QString &dest,
                             QDropEvent::Action action);
    static bool recursiveParseDir(const QString &path,
                                  QStringList &fileList,
                                  bool requireDeletePerms,
                                  bool requireReadPerms,
                                  bool processPicsDir,
                                  bool folderNameBeforeContents);

    static bool move(const QString &src, const QString &dest,
                     bool handleThumbs = true);
    static bool copy(const QString &src, const QString &dest,
                     bool handleThumbs = true);
    static bool makelink(const QString &src, const QString &dest);
    static bool makesymlink(const QString &src, const QString &dest);

    static bool moveThumbnails(const QString &src, const QString &dest,
                               bool move = true);
    static bool copyFolder(const QString &src, const QString &dest);
    static bool moveFolder(const QString &src, const QString &dest);
};





#endif

