#ifndef __KIF_CATAGORYMGR_H
#define __KIF_CATAGORYMGR_H

#include <qstringlist.h>
#include <qintdict.h>
#include <qobject.h>

typedef struct __catinfo{
    unsigned char catagories[8];
}CatInfo;

class CatagoryManager : public QObject
{
    Q_OBJECT
public:
    CatagoryManager(QObject *parent=0, const char *name=0);
    ~CatagoryManager();
    void insertStringList(const QStringList &list);
    bool sync();
    void clear();
    int count(){return(numItems);}
    QString** array(){return(catarray);}
    QStringList* catagoryList(){return(&nameList);}
    int id(const QString &catagory);

    bool loadFolderCatagories(const QString &currentDir,
                              QIntDict<CatInfo> *catDict);
    bool saveFolderCatagories(const QString &currentDir,
                              QIntDict<CatInfo> *catDict);
signals:
    void changed();
protected:
    bool readDb();
    bool writeDb();

    QString *catarray[256];
    int numItems;
    QStringList nameList;
};

#endif

