#include "about.h"
#include "browser.h"
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qimage.h>
#include <stdlib.h>
#include <kbuttonbox.h>
#include <klocale.h>


KIFAboutDialog::KIFAboutDialog(QWidget *parent, const char *name)
    : QDialog(parent, name, true)
{
    QVBoxLayout *layout = new QVBoxLayout(this);
    QFrame *frame = new QFrame(this);
    QGridLayout *frameLayout = new QGridLayout(frame, 1, 1, 5);

    QBrush bgBrush(Qt::white);
    QPalette pal(palette());
    pal.setBrush(QColorGroup::Background, bgBrush);
    frame->setPalette(pal);
    frame->setFrameStyle(QFrame::StyledPanel | QFrame::Raised);
    frame->setLineWidth(2);

    QPixmap logoPix;
    logoPix.convertFromImage(PixieBrowser::uicImage("aboutlogo.png"));

    QLabel *lbl = new QLabel(frame);
    lbl->setAlignment(Qt::AlignCenter);
    lbl->setPixmap(logoPix);
    frameLayout->addMultiCellWidget(lbl, 0, 0, 0, 1);

    lbl = new QLabel(i18n("Image and Photo Manager"), frame);
    lbl->setAlignment(Qt::AlignCenter);
    frameLayout->addMultiCellWidget(lbl, 1, 1, 0, 1);

    lbl = new QLabel(i18n("(C)BSD 2000-2003"), frame);
    lbl->setAlignment(Qt::AlignCenter);
    frameLayout->addMultiCellWidget(lbl, 2, 2, 0, 1);

    frameLayout->addRowSpacing(3, 5);
    QPixmap eyesPix;
    eyesPix.convertFromImage(PixieBrowser::uicImage("eyes.png"));

    lbl = new QLabel(frame);
    lbl->setAlignment(Qt::AlignCenter);
    lbl->setPixmap(eyesPix);
    frameLayout->addMultiCellWidget(lbl, 4, 5, 0, 0);

    lbl = new QLabel(i18n("Daniel M. Duley"), frame);
    lbl->setAlignment(Qt::AlignVCenter);
    frameLayout->addMultiCellWidget(lbl, 4, 4, 1, 1);

    lbl = new QLabel(i18n("<dan.duley@verizon.net>"), frame);
    lbl->setAlignment(Qt::AlignVCenter);
    frameLayout->addMultiCellWidget(lbl, 5, 5, 1, 1);

    frameLayout->addRowSpacing(6, 5);

    lbl = new QLabel(i18n("Special thanks:\n\
John Cristy for ImageMagick\n\
Lignum Computing for Qt XCF suppory\n\
Greg Roelofs of libpng.org for fast answers\n\
Eric Raymond for GIFLib"), frame);

    lbl->setAlignment(Qt::AlignCenter);
    frameLayout->addMultiCellWidget(lbl, 7, 7, 0, 1);

    frameLayout->setColStretch(2, 1);
    frameLayout->setRowStretch(8, 1);

    layout->addWidget(frame);
    layout->addStretch();

    QPushButton *okayBtn = new QPushButton(i18n("OK"), this);
    connect(okayBtn, SIGNAL(clicked()), this,
            SLOT(accept()));
    layout->addWidget(okayBtn);

    setCaption(i18n("About PixiePlus"));


}






