sub Generate_IMG($$$$$$$)
{
	my $Type = shift;
	my $From = shift;
	my $To = shift;

	my $Filter = shift;
	my $Label = shift;

	my $Stat_Type = shift; # Time/Top

	my $Parameters = shift;

	  # Objects initialisation :
	my $Stat = Statistic->new();

	  # Statistic type :
	$Stat->Type( $Stat_Type );

	  # Set Stat-Type specific parameters :
	foreach my $key ( keys %{ $Parameters } )
	{
		$Stat->Parameters()->{$key} = $Parameters->{$key};
	}

	  # Set Statistic label :
	$Stat->Label( $Label );

	  # Add this filter to the Statistic object :
	$Stat->addFilter( $Filter );

	  # Set Time format + start and end periods :
	$Stat->KeyType( $Type );
	$Stat->From( $From );
	$Stat->To( $To );

	  # Gather data from the database :
	$Stat->prepare_display();

	my $res = $Stat->display();

	if ( ! $res ) { return 0; };
	return $Stat->Parameters()->{'Graph_FileName'};
}

sub Generate_PDF_Page($$$$$$$$$)
{
	my $PDF_Object = shift;

	my $Type = shift;
	my $From = shift;
	my $To = shift;

	my $Filter = shift;

	my $pages = shift;
	my $new_page = shift;

	my $Stat_Type = shift;
	my $Parameters = shift;

	  # Get current page number and set filename for generated image :
	$Parameters->{'Graph_FileName'} = 'generated/Images/tmp_pdfreport'.( $PDF_Object->pages + 1 ).'.png' ;

	  # Create the image :
	my $FileName = Generate_IMG( $Type, $From, $To, $Filter, $new_page->{'page_title'}, $Stat_Type, $Parameters );
	if ( ! $FileName ) {return 0; };

	#

	add_page_to_list( $pages, $new_page, 0 );

	#

	  # Create a new page : ( 0 = append at the end )
	my $page = $PDF_Object->page( 0 );

	  # Set page format :
#	$page->mediabox( 'A3' );
	$page->mediabox( 842, 1190 );
#	$page->mediabox( 842, 595 ); # rotated A4

	  # Load a jpeg image to incorporate in the PDF :
	my $image = $PDF_Object->image_jpeg( $FileName );

	my $x = (  842 - $Parameters->{'Graph_Width'} ) / 2;
	my $y = ( 1190 - $Parameters->{'Graph_Height'} - 2 );

	  # Incorporate image in the PDF with a 100% size :
	my $gfx = $page->gfx;
	$gfx->image( $image, $x, $y, 100/100 );

	my $comment = $Filter->comment();
	$comment =~ s/<br>/\n/mg;

	  # Bold text is on his own line :
	$comment =~ s/<\/b>/<\/b>\n/mg;

	  # Suppress multiple CR :
	$comment =~ s/\n+/\n/mg;

	  # Nessus wraps text badly :
	$comment =~ s/([a-z])\s*\n([a-z])/$1 $2/mg;

	  # Multiple infos for this port :
	$comment =~ s/<hr>/\n/mg;

	  # Security HOLE :
	$comment =~ s/<font color=red>//mg;
	$comment =~ s/<\/font>//mg;

	my @blocs = split( /\n/m, $comment );

	my $font_std = $PDF_Object->corefont( 'Helvetica', 1 );
	$font_std->encode( 'latin1' );

	my $font_bold = $PDF_Object->corefont( 'Helvetica-Bold', 1 );
	$font_bold->encode( 'latin1' );

	$y -= 20;
	my $x_offset = 20;

	foreach my $bloc ( @blocs )
	{
		if ( $y > 0 )
		{
			my $text = $page->text;

			if ( $bloc =~ m/<b>.*<\/b>/i )
			{
				$bloc =~ s/<b>//g;
				$bloc =~ s/<\/b>//g;
				$text->font( $font_bold, 12 );
			}
			else
			{
				$text->font( $font_std, 10 );
			}

			my ( $x_tmp, $y_tmp, $o_tmp ) = $text->paragraph(
				$bloc,
				-x => ( $x + $x_offset ),
				-y => $y,
				-w => ( $Parameters->{'Graph_Width'} - 2*$x_offset ),
				-h => $y
			);
			$y = $y_tmp;
		}
	}

	#

	return 1;
}

sub copy_page($)
{
	my $old_page = shift;

	my $new_page = {};

	foreach my $key ( keys %{ $old_page } )
	{
		$new_page->{$key} = $old_page->{$key};
	}

	return $new_page;
}

sub sort_pages($$)
{
	my $a = shift;
	my $b = shift;

	my $comp1 = ( $a->{'section_id'} <=> $b->{'section_id'} );
	if ( $comp1 ) { return $comp1; };

	my $comp2 = ( $a->{'page_type'} <=> $b->{'page_type'} );
	if ( $comp2 ) { return $comp2; };

	my $comp3 = ( $a->{'section_title'} cmp $b->{'section_title'} );
	return $comp3;
}

sub add_page_to_list($$$)
{
	my $pages = shift; # Array Ref to the page-list
	my $new_page = shift; # New page
	my $sort = shift;

	# 'section_id'		# Section number
	# 'section_title'	# Section title
	# 'page_title'		# Page title
	# 'page_type'		# 0 = title_cut_page, 1 = statistic, 2 = summary page

	  # Insert this new page :
	push @{ $pages }, { %{ $new_page } };

	if ( $sort )
	{
		  # Sort those pages :
		@{ $pages } = sort sort_pages @{ $pages };

		  # Look for new page position in the list :
		my $position = 0;
		foreach my $page ( @{ $pages } )
		{
			if (
			  ( $page->{'section_id'}    eq $new_page->{'section_id'}    ) and 
			  ( $page->{'section_title'} eq $new_page->{'section_title'} ) and
			  ( $page->{'page_title'}    eq $new_page->{'page_title'}    ) and
			  ( $page->{'page_type'}     eq $new_page->{'page_type'}     )
			)
			{
				  # In PDF::API2, page nb starts at 1 : (0 in this table)
				return ( $position + 1 );
			}
			$position++;
		}

		print "Problem, inserted page not found\n";
	}
}

sub net_topology_page($$$$)
{
	my $PDF_Object = shift;
	my $network_topology_image = shift;

	my $pages = shift;
	my $new_page = shift;

	if ( -f $network_topology_image->{'path'} )
	{
		$new_page->{'section_id'} ++;
		$new_page->{'section_title'} = 'Network topology';

		my $current_page = copy_page( $new_page );
		$current_page->{'page_title'} = 'Network topology';

		my %image_fct = (
			'jpeg' => 'image_jpeg',
			'png' => 'image_png'
		);

		  # Insert page in document structure and get its position in the PDF :
		my $position = add_page_to_list( $pages, $current_page, 1 );

		  # Create a new page : ( 0 = append at the end )
		my $page = $PDF_Object->page( $position );

		  # Set page format :
#		$page->mediabox( 'A3' );
		$page->mediabox( 842, 1190 );
#		$page->mediabox( 842, 595 ); # rotated A4

		  # Load a jpeg image to incorporate in the PDF :
		my $image = '';
		eval( "\$image = \$PDF_Object->".$image_fct{$network_topology_image->{'type'}}."( \$network_topology_image->{'path'} );" );

		my $x = (  842 - $network_topology_image->{'width'} ) / 2;
		my $y = ( 1190 - $network_topology_image->{'height'} ) / 2;

		  # Incorporate image in the PDF with a 100% size :
		my $gfx = $page->gfx;
		$gfx->image( $image, $x, $y, 100/100 );
	}
	else
	{
		print "No network topology page\n";
	}
}

sub title_cut_page($$$$)
{
	my $PDF_Object = shift;
	my $Parameters = shift;

	my $pages = shift;
	my $new_page = shift;

	  # Insert page in document structure and get its position in the PDF :
	my $position = add_page_to_list( $pages, $new_page, 1 );

# print ">Insert title page \"".( $new_page->{'section_title'} )."\" at pos $position\n";

	  # Create a new page : ( 0 = append at the end )
	my $page = $PDF_Object->page( $position );

	  # Set page format :
#	$page->mediabox( 'A3' );
	$page->mediabox( 842, 1190 );
#	$page->mediabox( 842, 595 ); # rotated A4

	#

	my $font_bold = $PDF_Object->corefont( 'Helvetica-Bold', 1 );
	$font_bold->encode( 'latin1' );

	my $x = (  842 - $Parameters->{'Graph_Width'} )/2;
	my $y = ( 1190 - $Parameters->{'Graph_Height'} - 2 );
	$y -= 20;
	my $x_offset = 20;

	foreach my $bloc ( split( /\|/, $new_page->{'section_title'} ) )
	{
		if ( $y > 0 )
		{
			my $text = $page->text;
			$text->font( $font_bold, 30 );

			my ( $x_tmp, $y_tmp, $o_tmp ) = $text->paragraph(
				$bloc,
				-x => ( $x + $x_offset ),
				-y => $y,
				-w => ( $Parameters->{'Graph_Width'} - 2*$x_offset ),
				-h => $y
			);
			$y = $y_tmp;
		}
	}
}

=pod

generate_report_statistic_page(
{
	'Statistic_Stat_Type' => 'Time', # Time/Top
	'Statistic_Time_Type' => $Type,
	'Statistic_Time_From' => $From,
	'Statistic_Time_To' => $To,
	'Statistic_Filter' => $Filter,
	'Statistic_Parameters' => $Parameters,

	'PDF' => $pdf,
	'PDF_Pages' => $pages,
	'PDF_Page_Template' => $new_page,
	'PDF_Page_Title' => 'Attacks per '.$Type_to_PeriodName{$Type},
}
);

=cut

sub generate_report_statistic_page($)
{
	my $data = shift;

	my $current_page = copy_page( $data->{'PDF_Page_Template'} );
	$current_page->{'page_title'} = $data->{'PDF_Page_Title'};

	my $ret = Generate_PDF_Page(
		$data->{'PDF'},
		$data->{'Statistic_Time_Type'},
		$data->{'Statistic_Time_From'},
		$data->{'Statistic_Time_To'},
		$data->{'Statistic_Filter'},
		$data->{'PDF_Pages'},
		$current_page,
		$data->{'Statistic_Stat_Type'},
		$data->{'Statistic_Parameters'}
	);

	if ( ! $ret ) { print "No data available for this time period (page '".( $data->{'PDF_Page_Title'} )."')\n"; };
}

sub delete_tmp_images($)
{
	my $img_dir = shift;

	if ( -d $img_dir )
	{
		local *DIRECTORY;
		opendir( DIRECTORY, $img_dir );
		foreach my $DirEntry ( sort readdir( DIRECTORY ) )
		{
			if ( $DirEntry =~ m/^tmp_pdfreport\d+\.jpg$/i )
			{
				unlink $img_dir.'/'.$DirEntry;
			}
		}
	}
}

1;
