package BaseObject;
our $VERSION = '2004-01-17';	# Versionning
our $AUTOLOAD;					# for hidden set & get with field name

no strict 'refs';

sub new {
	my $proto = shift;
	my $class = ref( $proto ) || $proto;

	my $self  = {};

	bless ( $self, $class );

	#

	return $self;
}

#############################################################################

sub get($$)
{
	my $self = shift;
	my $AttributeName = shift;

	if ( $AttributeName and exists( $self->{$AttributeName} ) )
	{
		return $self->{$AttributeName};
	}
	else
	{
		return undef;
	}
}

sub set($$$)
{
	my $self = shift;
	my $AttributeName = shift;
	my $Value = shift;

	if ( $AttributeName and exists( $self->{$AttributeName} ) )
	{
		$self->{$AttributeName} = $Value;
		return $Value;
	}
	else
	{
		return undef;
	}
}

sub AUTOLOAD
{
	my $self = shift;
	my $value = shift;

	my $type = ref( $self ) or die "$self is not an object";

	my $name = $AUTOLOAD;
	$name =~ s/.*://;   # strip fully-qualified portion

	if ( $name and exists( $self->{$name} ) )
	{
		if ( defined( $value ) )
		{
			return $self->{$name} = $value;
		}
		else
		{
			return $self->{$name};
		}
	}
	else
	{
		if ( $name ne 'DESTROY' )
		{
			print "$AUTOLOAD - > $name : inconnu dans la Classe $type\n";
			die "Can't access `$name' field in class $type";
		}
	}
}

1;
