/*********************************************************************
 *                
 * Copyright (C) 2003, 2005,  Karlsruhe University
 *                
 * File path:     kdb/glue/v4-ia32/thread.cc
 * Description:   Various thread management stuff
 *                
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *                
 * $Id: thread.cc,v 1.2.2.2 2005/06/06 16:15:28 skoglund Exp $
 *                
 ********************************************************************/
#include <debug.h>
#include <kdb/kdb.h>
#include <kdb/cmd.h>
#include <kdb/input.h>

#include INC_API(tcb.h)

void ia32_dump_frame (ia32_exceptionframe_t * frame);


DECLARE_CMD (cmd_dump_frame, root, 'F', "dumpframe",
	     "show exception frame");

CMD (cmd_dump_frame, cg)
{
    tcb_t * current = get_thread ("Thread");
    ia32_exceptionframe_t * f =
	(ia32_exceptionframe_t *) current->get_stack_top () - 1;

    word_t frame = get_hex ("Frame", (word_t) f, "current user frame");
    ia32_dump_frame ((ia32_exceptionframe_t *) frame);

    return CMD_NOQUIT;
}
