/*********************************************************************
 *                
 * Copyright (C) 2003,  National ICT Australia (NICTA)
 *                
 * File path:     kdb/arch/powerpc64/spr.cc
 * Description:   Special Purpose Register Commands
 *                
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *                
 * $Id: spr.cc,v 1.1.2.1 2004/06/04 16:02:41 skoglund Exp $
 *                
 ********************************************************************/

#include <debug.h>
#include <kdb/cmd.h>
#include <kdb/kdb.h>

#include INC_ARCH(ppc64_registers.h)


/**
 * cmd_powerpc64_spr_show: dump powerpc64 sprs
 */
DECLARE_CMD (cmd_powerpc64_spr_show, arch, 'r', "spr", "show SPR registers");

CMD(cmd_powerpc64_spr_show, cg)
{
    word_t val;

    printf( "--- Special Purpose Registers ---\n" );

    val = ppc64_get_spr( SPR_DSISR );
    printf( "DSISR (%d)  = %016lx\n", SPR_DSISR, val );
    val = ppc64_get_spr( SPR_DAR );
    printf( "DAR (%d)    = %016lx\n", SPR_DAR, val );
    val = ppc64_get_spr( SPR_DEC );
    printf( "DEC (%d)    = %016lx\n", SPR_DEC, val );
    val = ppc64_get_spr( SPR_SDR1 );
    printf( "SDR1 (%d)   = %016lx\n", SPR_SDR1, val );
    val = ppc64_get_spr( SPR_SRR0 );
    printf( "SRR0 (%d)   = %016lx\n", SPR_SRR0, val );
    val = ppc64_get_spr( SPR_SRR1 );
    printf( "SRR1 (%d)   = %016lx\n", SPR_SRR1, val );
    val = ppc64_get_spr( SPR_SPRG0 );
    printf( "SPRG0 (%d) = %016lx\n", SPR_SPRG0, val );
    val = ppc64_get_spr( SPR_SPRG1 );
    printf( "SPRG1 (%d) = %016lx\n", SPR_SPRG1, val );
    val = ppc64_get_spr( SPR_SPRG2 );
    printf( "SPRG2 (%d) = %016lx\n", SPR_SPRG2, val );
    val = ppc64_get_spr( SPR_SPRG3 );
    printf( "SPRG3 (%d) = %016lx\n", SPR_SPRG3, val );
    val = ppc64_get_spr( SPR_ASR );
    printf( "ASR (%d)   = %016lx\n", SPR_ASR, val );
    val = ppc64_get_spr( SPR_PVR );
    printf( "PVR (%d)   = %016lx\n", SPR_PVR, val );
    val = ppc64_get_spr( SPR_DABR );
    printf( "DABR (%d) = %016lx\n", SPR_DABR, val );

    printf( "\n" );

    return CMD_NOQUIT;
}


