/*
 * PIMPPA - File transformer
 *
 */

#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>

#include "pimppa.h"
#include "md5.h"

int Verbose=0;
	
int transform()
{
	MYSQL *src_db, *dst_db;
	MYSQL_RES *sql_res, *sql_res2;
	MYSQL_ROW sql_row, sql_row2;
	int passed_files=0, failed_files=0;
	int trans_status;
	int strict_md5;
	char *value;
	unsigned long long bytes_before=0, bytes_after=0;

/********* Connect databases *******************************/

	src_db=p_connect();
	if(!src_db)
		return(-2);

	dst_db=p_connect();
	if(!dst_db)
	{
		mysql_close(src_db);
		return(-2);
	}

	value=p_getmisc(src_db, P_KEY_STRICTMD5);
	if(value)
		strict_md5=atoi(value);
	else
		strict_md5=atoi(P_STRICTMD5);

/******** fetch files with suitable filenames & test status *******/
	
	fprintf(stderr, "Transforming files...\n");

	p_query(src_db, "SELECT file_name, file_area, file_id, "
			"  area_path, file_size "
			"FROM p_files, p_areas "
			"WHERE file_integ=%d AND file_trans=%d "
			"  AND NOT (file_flags & %ld) "
			"  AND file_area=area_id "
			"  AND NOT (area_flags & %ld) "
			"  AND NOT (area_flags & %ld) "
			"ORDER BY file_name",
		INTEG_PASSED,
		TRANS_NEW,
		FILE_OFFLINE,
		AREA_INCOMING,
		AREA_NOTRANS);
	if(mysql_error(src_db)[0])
		return(-1);
	sql_res=mysql_store_result(src_db);

	while((sql_row=mysql_fetch_row(sql_res)))
	{
		char *extension;
		char newname[PATH_MAX];
		char escaped_fn[2*P_LEN_FILE_NAME+1];
		char fullpath[PATH_MAX];
		char newfullpath[PATH_MAX];
		char *finalpath;
		int newsize,trans_failed;
		unsigned char md5sum[16], md5sum_esc[16*2+1];
		FILE *fp;
		int deleteme;
		
		finalpath=NULL;
		deleteme=0;
		newname[0]=0;
		trans_failed=1;									// Pessimistic, eh? =)
		trans_status=TRANS_NEW;
		newsize=atoi(sql_row[4]);						// Default to old size

		if(Verbose)
			fprintf(stderr, "%s", sql_row[0]);

		chdir(sql_row[3]);

		extension=strrchr(sql_row[0], '.');
		if(extension)
			extension++;

		p_query(dst_db, "SELECT type_transcmd, type_transto "
				"FROM p_types "			
				"WHERE type_ext='%s' "
				"  AND type_transcmd<>'' "
				"  AND type_transto<>''",
			(extension ? extension : ""));
		if(mysql_error(dst_db)[0])
		{
			fprintf(stderr, "Err: %s\n", mysql_error(dst_db));
			break;
		}
		sql_res2=mysql_store_result(dst_db);
		if(sql_res2 && (sql_row2=mysql_fetch_row(sql_res2)))
		{
			char buffer[PATH_MAX];
			struct stat st;
	
			sprintf(fullpath, "%s%s%s", 
					sql_row[3], 
					(p_checkp(sql_row[3]) ? "" : "/"),
					sql_row[0]);
			if(stat(fullpath, &st)!=0)
			{
				if(Verbose)
					fprintf(stderr, " - Offline!\n");
				
				p_query(dst_db, "UPDATE p_files "
						"SET file_flags=(file_flags | %ld) "
						"WHERE file_id=%s",
					FILE_OFFLINE, sql_row[2]);
				if(mysql_error(dst_db)[0])
					fprintf(stderr, "Err: %s\n", mysql_error(dst_db));

				continue;
			}

			sprintf(buffer, "%s \"%s\" 1>/dev/null 2>/dev/null", 
					sql_row2[0], fullpath);
			if(system(buffer)==0)							// Trans succeeded
			{
				struct stat st2;
				
				if(strcasecmp(extension, sql_row2[1])!=0)	// Ext changed?
				{
					int extloc=extension-sql_row[0];
					
					strncpy(newname, sql_row[0], extloc);	// Old namepart
					newname[extloc]=0;
					strcat(newname, sql_row2[1]);           // New extension
					if(Verbose)
						fprintf(stderr, " -> %s", newname);

					sprintf(newfullpath, "%s%s", sql_row[3], newname);
//					fprintf(stderr, "\nStatting %s\n", newfullpath);

					if(stat(newfullpath, &st2)==0)		// Check that new exists
					{
						newsize=st2.st_size;
						bytes_before+=atoi(sql_row[4]);
						trans_failed=0;
						finalpath=newfullpath;
					}
				}
				else
				{
//					fprintf(stderr, "\nStatting %s\n", fullpath);

					if(stat(fullpath, &st2)==0)		// Check that new exists
					{
						newsize=st2.st_size;
						bytes_before+=atoi(sql_row[4]);
						trans_failed=0;
						finalpath=fullpath;
					}
				}
			}
			
			if(trans_failed)
			{
				if(Verbose)
					fprintf(stderr, " - FAILED!\n");
				trans_status=TRANS_FAILED;
				failed_files++;
			}
			else
			{
				if(Verbose)
					fprintf(stderr, " - Passed, new size %f%%\n", 100*((float)newsize / (float)atoi(sql_row[4])));
				trans_status=TRANS_PASSED;
				passed_files++;
				bytes_after+=newsize;
			}	
		}
		else 
		{
			if(Verbose)
				fprintf(stderr, " - Unknown filetype\n");

			trans_status=TRANS_UNKNOWN;
		}
		if(sql_res2)
			mysql_free_result(sql_res2);

		if(trans_status!=TRANS_PASSED)
		{
			p_query(dst_db, "UPDATE p_files "
					"SET file_trans=%d "
					"WHERE file_id=%s",
				trans_status, sql_row[2]);
			continue;
		}			

		if(newname[0])
			mysql_escape_string(escaped_fn, newname, strlen(newname));
		else
			mysql_escape_string(escaped_fn, sql_row[0], strlen(sql_row[0]));

		// Calc md5sum
		memset(md5sum, 0, 16);
		fp=fopen(finalpath, "rb");
		if(fp)
		{
			if(md5_stream(fp, md5sum))
				fprintf(stderr, "md5_stream() fail on %s\n", finalpath);
	
			fclose(fp);
		}
		else
			fprintf(stderr, "fopen() fail on %s\n", finalpath);
			
		mysql_escape_string((char *)md5sum_esc, (char *)md5sum, 16);

		// if STRICT: Delete both original & transformed file on collision	
		if(strict_md5)
		{
			p_query(dst_db, "SELECT 1 FROM p_files "
					"WHERE file_md5sum='%s' "
					"  AND file_id<>%s",
				md5sum_esc, sql_row[2]);
			sql_res2=mysql_store_result(dst_db);
			if(sql_res2)
			{	
				if(mysql_num_rows(sql_res2)>0)
				{
					deleteme=1;
					
					if(Verbose)
					{
						int cnt;
					
						fprintf(stderr, "Transformed md5sum ");
						for(cnt=0;cnt<16;cnt++)
							fprintf(stderr, "%02x", (unsigned char)md5sum[cnt]);
						fprintf(stderr,	" collides. Deleted.\n");
					}
				}
				mysql_free_result(sql_res2);
			}
		}
			
		if(deleteme)
		{
			p_query(dst_db, "DELETE FROM p_files "
					"WHERE file_id=%s", 
				sql_row[2]);
			remove(fullpath);
			remove(newfullpath);
			bytes_after-=newsize;
		}
		else
		{
			p_query(dst_db, "UPDATE p_files "
					"SET file_trans=%d,file_size=%d, "
					"  file_name='%s',file_md5sum='%s' "
					"WHERE file_id=%s",
				trans_status, newsize, escaped_fn, 
				md5sum_esc, sql_row[2]);
			if(mysql_error(dst_db)[0])
			{
				fprintf(stderr, "Error: %s\n", mysql_error(dst_db));
				continue;
			}
			if(newname[0])
				remove(fullpath);					// Remove old file
		}
	}
	mysql_free_result(sql_res);

	fprintf(stderr, "%d transformed, %d passed and %d failed. %lld bytes gain.\n",
					passed_files+failed_files, passed_files,
					failed_files, bytes_before-bytes_after);

	mysql_close(dst_db);
	mysql_close(src_db);
	
	return(1);
}
	

int main(int argc, char *argv[])
{
	int go=1;

	while(go)
	{
		switch(getopt(argc, argv, "hvV"))
		{
			case 'h':
				fprintf(stderr, "Usage: %s [-v]\n\n-v   Verbose\n\n",
						argv[0]);
				return(0);
				break;
			case 'v':
				Verbose=1;
				break;
			case 'V':
				printf("%s %s %s\n", PACKAGE, argv[0], VERSION);
				return(0);
				break;
			default:
				go=0;
				break;
		}
	}

	transform();
	
	return(0);
}

